"use strict";module.exports=Type;var Namespace=require("./namespace");((Type.prototype=Object.create(Namespace.prototype)).constructor=Type).className="Type";var Enum=require("./enum"),OneOf=require("./oneof"),Field=require("./field"),MapField=require("./mapfield"),Service=require("./service"),Message=require("./message"),Reader=require("./reader"),Writer=require("./writer"),util=require("./util"),encoder=require("./encoder"),decoder=require("./decoder"),verifier=require("./verifier"),converter=require("./converter"),wrappers=require("./wrappers");function Type(e,t){Namespace.call(this,e,t),this.fields={},this.oneofs=void 0,this.extensions=void 0,this.reserved=void 0,this.group=void 0,this._fieldsById=null,this._fieldsArray=null,this._oneofsArray=null,this._ctor=null}function clearCache(e){return e._fieldsById=e._fieldsArray=e._oneofsArray=null,delete e.encode,delete e.decode,delete e.verify,e}Object.defineProperties(Type.prototype,{fieldsById:{get:function(){if(this._fieldsById)return this._fieldsById;this._fieldsById={};for(var e=Object.keys(this.fields),t=0;t<e.length;++t){var r=this.fields[e[t]],i=r.id;if(this._fieldsById[i])throw Error("duplicate id "+i+" in "+this);this._fieldsById[i]=r}return this._fieldsById}},fieldsArray:{get:function(){return this._fieldsArray||(this._fieldsArray=util.toArray(this.fields))}},oneofsArray:{get:function(){return this._oneofsArray||(this._oneofsArray=util.toArray(this.oneofs))}},ctor:{get:function(){return this._ctor||(this.ctor=Type.generateConstructor(this)())},set:function(e){var t=e.prototype;t instanceof Message||((e.prototype=new Message).constructor=e,util.merge(e.prototype,t)),e.$type=e.prototype.$type=this,util.merge(e,Message,!0),this._ctor=e;for(var r=0;r<this.fieldsArray.length;++r)this._fieldsArray[r].resolve();var i={};for(r=0;r<this.oneofsArray.length;++r)i[this._oneofsArray[r].resolve().name]={get:util.oneOfGetter(this._oneofsArray[r].oneof),set:util.oneOfSetter(this._oneofsArray[r].oneof)};r&&Object.defineProperties(e.prototype,i)}}}),Type.generateConstructor=function(e){for(var t,r=util.codegen(["p"],e.name),i=0;i<e.fieldsArray.length;++i)(t=e._fieldsArray[i]).map?r("this%s={}",util.safeProp(t.name)):t.repeated&&r("this%s=[]",util.safeProp(t.name));return r("if(p)for(var ks=Object.keys(p),i=0;i<ks.length;++i)if(p[ks[i]]!=null)")("this[ks[i]]=p[ks[i]]")},Type.fromJSON=function(e,t){var r=new Type(e,t.options);r.extensions=t.extensions,r.reserved=t.reserved;for(var i=Object.keys(t.fields),s=0;s<i.length;++s)r.add((void 0!==t.fields[i[s]].keyType?MapField.fromJSON:Field.fromJSON)(i[s],t.fields[i[s]]));if(t.oneofs)for(i=Object.keys(t.oneofs),s=0;s<i.length;++s)r.add(OneOf.fromJSON(i[s],t.oneofs[i[s]]));if(t.nested)for(i=Object.keys(t.nested),s=0;s<i.length;++s){var o=t.nested[i[s]];r.add((void 0!==o.id?Field.fromJSON:void 0!==o.fields?Type.fromJSON:void 0!==o.values?Enum.fromJSON:void 0!==o.methods?Service.fromJSON:Namespace.fromJSON)(i[s],o))}return t.extensions&&t.extensions.length&&(r.extensions=t.extensions),t.reserved&&t.reserved.length&&(r.reserved=t.reserved),t.group&&(r.group=!0),t.comment&&(r.comment=t.comment),t.edition&&(r._edition=t.edition),r._defaultEdition="proto3",r},Type.prototype.toJSON=function(e){var t=Namespace.prototype.toJSON.call(this,e),r=!!e&&!!e.keepComments;return util.toObject(["edition",this._editionToJSON(),"options",t&&t.options||void 0,"oneofs",Namespace.arrayToJSON(this.oneofsArray,e),"fields",Namespace.arrayToJSON(this.fieldsArray.filter(function(e){return!e.declaringField}),e)||{},"extensions",this.extensions&&this.extensions.length?this.extensions:void 0,"reserved",this.reserved&&this.reserved.length?this.reserved:void 0,"group",this.group||void 0,"nested",t&&t.nested||void 0,"comment",r?this.comment:void 0])},Type.prototype.resolveAll=function(){if(!this._needsRecursiveResolve)return this;Namespace.prototype.resolveAll.call(this);var e=this.oneofsArray;for(r=0;r<e.length;)e[r++].resolve();for(var t=this.fieldsArray,r=0;r<t.length;)t[r++].resolve();return this},Type.prototype._resolveFeaturesRecursive=function(e){return this._needsRecursiveFeatureResolution&&(e=this._edition||e,Namespace.prototype._resolveFeaturesRecursive.call(this,e),this.oneofsArray.forEach(t=>{t._resolveFeatures(e)}),this.fieldsArray.forEach(t=>{t._resolveFeatures(e)})),this},Type.prototype.get=function(e){return util.getProp(this.fields,e)||util.getProp(this.oneofs,e)||util.getProp(this.nested,e)||null},Type.prototype.add=function(e){if(this.get(e.name))throw Error("duplicate name '"+e.name+"' in "+this);if(e instanceof Field&&void 0===e.extend){if(this._fieldsById?this._fieldsById[e.id]:this.fieldsById[e.id])throw Error("duplicate id "+e.id+" in "+this);if(this.isReservedId(e.id))throw Error("id "+e.id+" is reserved in "+this);if(this.isReservedName(e.name))throw Error("name '"+e.name+"' is reserved in "+this);return e.parent&&e.parent.remove(e),this.fields[e.name]=e,e.message=this,e.onAdd(this),clearCache(this)}return e instanceof OneOf?(this.oneofs||(this.oneofs={}),this.oneofs[e.name]=e,e.onAdd(this),clearCache(this)):Namespace.prototype.add.call(this,e)},Type.prototype.remove=function(e){if(e instanceof Field&&void 0===e.extend){if(!this.fields||this.fields[e.name]!==e)throw Error(e+" is not a member of "+this);return delete this.fields[e.name],e.parent=null,e.onRemove(this),clearCache(this)}if(e instanceof OneOf){if(!this.oneofs||this.oneofs[e.name]!==e)throw Error(e+" is not a member of "+this);return delete this.oneofs[e.name],e.parent=null,e.onRemove(this),clearCache(this)}return Namespace.prototype.remove.call(this,e)},Type.prototype.isReservedId=function(e){return Namespace.isReservedId(this.reserved,e)},Type.prototype.isReservedName=function(e){return Namespace.isReservedName(this.reserved,e)},Type.prototype.create=function(e){return new this.ctor(e)},Type.prototype.setup=function(){for(var e=this.fullName,t=[],r=0;r<this.fieldsArray.length;++r)t.push(this._fieldsArray[r].resolve().resolvedType);this.encode=encoder(this)({Writer:Writer,types:t,util:util}),this.decode=decoder(this)({Reader:Reader,types:t,util:util}),this.verify=verifier(this)({types:t,util:util}),this.fromObject=converter.fromObject(this)({types:t,util:util}),this.toObject=converter.toObject(this)({types:t,util:util});var i=wrappers[e];if(i){var s=Object.create(this);s.fromObject=this.fromObject,this.fromObject=i.fromObject.bind(s),s.toObject=this.toObject,this.toObject=i.toObject.bind(s)}return this},Type.prototype.encode=function(e,t){return this.setup().encode(e,t)},Type.prototype.encodeDelimited=function(e,t){return this.encode(e,t&&t.len?t.fork():t).ldelim()},Type.prototype.decode=function(e,t){return this.setup().decode(e,t)},Type.prototype.decodeDelimited=function(e){return e instanceof Reader||(e=Reader.create(e)),this.decode(e,e.uint32())},Type.prototype.verify=function(e){return this.setup().verify(e)},Type.prototype.fromObject=function(e){return this.setup().fromObject(e)},Type.prototype.toObject=function(e,t){return this.setup().toObject(e,t)},Type.d=function(e){return function(t){util.decorateType(t,e)}};