"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = shadowRoot;

var _shadowFnFactory = require("../../scripts/shadowFnFactory");

/**
 *
 * Access an element inside a given element's shadowRoot
 *
 * <example>
    :shadow$$.js
    it('should return an element inside a shadowRoot', () => {
        const innerEl = $('.input').shadow$('#innerEl');
        console.log(innerEl.getValue()); // outputs: 'test123'
    });
 * </example>
 *
 * @alias element.shadow$
 * @uses commands/$
 * @type action
 *
 */
async function shadowRoot(selector) {
  return await this.$((0, _shadowFnFactory.shadowFnFactory)(selector));
}