"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = scrollIntoView;

/**
 *
 * Scroll element into viewport.
 *
 * <example>
    :scrollIntoView.js
    it('should demonstrate the scrollIntoView command', () => {
        const elem = $('#myElement');
        // scroll to specific element
        elem.scrollIntoView();
    });
 * </example>
 *
 * @alias element.scrollIntoView
 * @uses protocol/execute
 * @type utility
 *
 */
function scrollIntoView() {
  return this.parent.execute(
  /* istanbul ignore next */
  elem => elem.scrollIntoView(), {
    ELEMENT: this.elementId
  });
}