"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isDisplayedInViewport;

var _constants = require("../../constants");

var _utils = require("../../utils");

var _isDisplayedInViewport = _interopRequireDefault(require("../../scripts/isDisplayedInViewport"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 *
 * Return true if the selected DOM-element found by given selector is visible and within the viewport.
 *
 * <example>
    :index.html
    <div id="notDisplayed" style="display: none"></div>
    <div id="notVisible" style="visibility: hidden"></div>
    <div id="notInViewport" style="position:absolute; left: 9999999"></div>
    <div id="zeroOpacity" style="opacity: 0"></div>
    :isVisibleWithinViewport.js
    :isVisible.js
    it('should detect if an element is visible', () => {
        let isVisibleWithinViewport = $('#notDisplayed').isVisibleWithinViewport();
        console.log(isVisibleWithinViewport); // outputs: false

        isVisibleWithinViewport = $('#notVisible').isVisibleWithinViewport();
        console.log(isVisibleWithinViewport); // outputs: false

        isVisibleWithinViewport = $('#notExisting').isVisibleWithinViewport();
        console.log(isVisibleWithinViewport); // outputs: false

        isVisibleWithinViewport = $('#notInViewport').isVisibleWithinViewport();
        console.log(isVisibleWithinViewport); // outputs: false

        isVisibleWithinViewport = $('#zeroOpacity').isVisibleWithinViewport();
        console.log(isVisibleWithinViewport); // outputs: false
    });
 * </example>
 *
 * @alias element.isVisibleWithinViewport
 * @return {Boolean}            true if element(s)* [is|are] visible
 * @uses protocol/selectorExecute, protocol/timeoutsAsyncScript
 * @type state
 *
 */
function isDisplayedInViewport() {
  return (0, _utils.getBrowserObject)(this).execute(_isDisplayedInViewport.default, {
    [_constants.ELEMENT_KEY]: this.elementId,
    // w3c compatible
    ELEMENT: this.elementId // jsonwp compatible

  });
}