"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = isDisplayed;

/**
 *
 * Return true if the selected DOM-element is displayed.
 *
 * <example>
    :index.html
    <div id="notDisplayed" style="display: none"></div>
    <div id="notVisible" style="visibility: hidden"></div>
    <div id="notInViewport" style="position:absolute; left: 9999999"></div>
    <div id="zeroOpacity" style="opacity: 0"></div>
    :isDisplayed.js
    it('should detect if an element is displayed', () => {
        let elem = $('#notDisplayed');
        let isDisplayed = elem.isDisplayed();
        console.log(isDisplayed); // outputs: false

        elem = $('#notVisible');

        isDisplayed = elem.isDisplayed();
        console.log(isDisplayed); // outputs: false

        elem = $('#notExisting');
        isDisplayed = elem.isDisplayed();
        console.log(isDisplayed); // outputs: false

        elem = $('#notInViewport');
        isDisplayed = elem.isDisplayed();
        console.log(isDisplayed); // outputs: true

        elem = $('#zeroOpacity');
        isDisplayed = elem.isDisplayed();
        console.log(isDisplayed); // outputs: true
    });
 * </example>
 *
 * @alias element.isDisplayed
 * @return {Boolean} true if element(s)* [is|are] displayed
 * @uses protocol/elements, protocol/elementIdDisplayed
 * @type state
 *
 */
async function isDisplayed() {
  /*
   * This is only necessary as isDisplayed is on the exclusion list for the middleware
   */
  if (!this.elementId) {
    this.elementId = (await this.parent.$(this.selector)).elementId;
  }

  return this.elementId ? await this.isElementDisplayed(this.elementId) : false;
}