"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getTagName;

/**
 *
 * Get tag name of a DOM-element.
 *
 * <example>
    :index.html
    <div id="elem">Lorem ipsum</div>

    :getTagName.js
    it('should demonstrate the getTagName command', () => {
        const elem = $('#elem');

        const tagName = elem.getTagName();
        console.log(tagName); // outputs: "div"
    })
 * </example>
 *
 * @alias element.getTagName
 * @return {String} the element's tag name, as a lowercase string
 * @uses protocol/elements, protocol/elementIdName
 * @type property
 *
 */
function getTagName() {
  return this.getElementTagName(this.elementId);
}