"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = newWindow;

var _newWindow = _interopRequireDefault(require("../../scripts/newWindow"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 *
 * Open new window in browser. This command is the equivalent function to `window.open()`. This command does not
 * work in mobile environments.
 *
 * __Note:__ When calling this command you automatically switch to the new window.
 *
 * <example>
    :newWindowSync.js
    it('should open a new tab', () => {
        browser.url('http://google.com')
        console.log(browser.getTitle()) // outputs: "Google"

        browser.newWindow('https://webdriver.io', 'WebdriverIO window', 'width=420,height=230,resizable,scrollbars=yes,status=1')
        console.log(browser.getTitle()) // outputs: "WebdriverIO · Next-gen WebDriver test framework for Node.js"

        browser.closeWindow()
        console.log(browser.getTitle()) // outputs: "Google"
    });
 * </example>
 *
 * @param {String} url            website URL to open
 * @param {String=} windowName     name of the new window
 * @param {String=} windowFeatures features of opened window (e.g. size, position, scrollbars, etc.)
 * @return {String}                id of window handle of new tab
 *
 * @uses browser/execute, protocol/getWindowHandles, protocol/switchToWindow
 * @alias browser.newWindow
 * @type window
 */
async function newWindow(url, windowName = 'New Window', windowFeatures = '') {
  /*!
   * parameter check
   */
  if (typeof url !== 'string') {
    throw new Error('number or type of arguments don\'t agree with newWindow command');
  }
  /*!
   * mobile check
   */


  if (this.isMobile) {
    throw new Error('newWindow command is not supported on mobile platforms');
  }

  await this.execute(_newWindow.default, url, windowName, windowFeatures);
  const tabs = await this.getWindowHandles();
  const newTab = tabs.pop();
  await this.switchToWindow(newTab);
  return newTab;
}