// Type definitions for WebDriver v5
// Project: https://www.npmjs.com/package/webdriver
// Definitions by: auto generated by https://github.com/webdriverio/webdriverio
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped
/// <reference types="node"/>

declare namespace WebDriver {
    type PageLoadingStrategy = 'none' | 'eager' | 'normal';
    type ProxyTypes = 'pac' | 'noproxy' | 'autodetect' | 'system' | 'manual';
    type WebDriverLogTypes = 'trace' | 'debug' | 'info' | 'warn' | 'error' | 'silent';
    type LoggingPreferenceType =
        'OFF' | 'SEVERE' | 'WARNING' |
        'INFO' | 'CONFIG' | 'FINE' |
        'FINER' | 'FINEST' | 'ALL';
    type FirefoxLogLevels =
        'trace' | 'debug' | 'config' |
        'info' | 'warn' | 'error' | 'fatal';
    type Timeouts = 'script' | 'pageLoad' | 'implicit';

    interface ProxyObject {
        proxyType?: ProxyTypes;
        proxyAutoconfigUrl?: string;
        ftpProxy?: string;
        ftpProxyPort?: number;
        httpProxy?: string;
        httpProxyPort?: number;
        sslProxy?: string;
        sslProxyPort?: number;
        socksProxy?: string;
        socksProxyPort?: number;
        socksVersion?: string;
        socksUsername?: string;
        socksPassword?: string;
    }

    interface LoggingPreferences {
        browser?: LoggingPreferenceType;
        driver?: LoggingPreferenceType;
        server?: LoggingPreferenceType;
        client?: LoggingPreferenceType;
    }

    interface Cookie {
        name: string;
        value: string;
        path?: string;
        httpOnly?: boolean;
        expiry?: number;
        secure?: boolean;
    }

    interface ChromeOptions {
        args?: string[];
        binary?: string;
        extensions?: string[];
        localState?: {
            [name: string]: any;
        };
        detach?: boolean;
        debuggerAddress?: string;
        excludeSwitches?: string[];
        minidumpPath?: string;
        mobileEmulation?: {
            [name: string]: any;
        };
        perfLoggingPrefs?: {
            [name: string]: any;
        };
        windowTypes?: string[];
    }

    interface FirefoxLogObject {
        level: FirefoxLogLevels
    }

    interface FirefoxOptions {
        binary?: string,
        args?: string[],
        profile?: string,
        log?: FirefoxLogObject,
        prefs: {
            [name: string]: string | number | boolean;
        }
    }

    interface Capabilities {
        browserName?: string;
        browserVersion?: string;
        platformName?: string;
        acceptInsecureCerts?: boolean;
        pageLoadStrategy?: PageLoadingStrategy;
        proxy?: ProxyObject;
        setWindowRect?: boolean;
        timeouts?: Timeouts;
        unhandledPromptBehavior?: string;
    }

    interface DesiredCapabilities extends Capabilities {
        // Read-only capabilities
        cssSelectorsEnabled?: boolean;
        handlesAlerts?: boolean;
        version?: string;
        platform?: string;

        // Read-write capabilities
        javascriptEnabled?: boolean;
        databaseEnabled?: boolean;
        locationContextEnabled?: boolean;
        applicationCacheEnabled?: boolean;
        browserConnectionEnabled?: boolean;
        webStorageEnabled?: boolean;
        acceptSslCerts?: boolean;
        rotatable?: boolean;
        nativeEvents?: boolean;
        unexpectedAlertBehaviour?: string;
        elementScrollBehavior?: number;

        // Grid-specific
        seleniumProtocol?: string;
        maxInstances?: number;
        environment?: string;

        // Selenium RC (1.0) only
        commandLineFlags?: string;
        executablePath?: string;
        timeoutInSeconds?: number;
        onlyProxySeleniumTraffic?: boolean;
        avoidProxy?: boolean;
        proxyEverything?: boolean;
        proxyRequired?: boolean;
        browserSideLog?: boolean;
        optionsSet?: boolean;
        singleWindow?: boolean;
        dontInjectRegex?: RegExp;
        userJSInjection?: boolean;
        userExtensions?: string;

        // RemoteWebDriver specific
        'webdriver.remote.sessionid'?: string;
        'webdriver.remote.quietExceptions'?: boolean;

        // Selenese-Backed-WebDriver specific
        'selenium.server.url'?: string;

        loggingPrefs?: {
            browser?: LoggingPreferences;
            driver?: LoggingPreferences;
            server?: LoggingPreferences;
            client?: LoggingPreferences;
        };

        // Firefox
        firefox_binary?: string;
        firefoxProfileTemplate?: string;
        captureNetworkTraffic?: boolean;
        addCustomRequestHeaders?: boolean;
        trustAllSSLCertificates?: boolean;
        changeMaxConnections?: boolean;
        profile?: string;
        pageLoadingStrategy?: string;
        'moz:firefoxOptions'?: FirefoxOptions;

        // IE specific
        'ie.forceCreateProcessApi'?: boolean;
        'ie.browserCommandLineSwitches'?: string;
        'ie.usePerProcessProxy'?: boolean;
        'ie.ensureCleanSession'?: boolean;
        'ie.setProxyByServer'?: boolean;
        ignoreProtectedModeSettings?: boolean;
        ignoreZoomSetting?: boolean;
        initialBrowserUrl?: string;
        enablePersistentHover?: boolean;
        enableElementCacheCleanup?: boolean;
        requireWindowFocus?: boolean;
        browserAttachTimeout?: number;
        logFile?: string;
        logLevel?: string;
        host?: string;
        extractPath?: string;
        silent?: string;
        killProcessesByName?: boolean;

        // Safari specific
        'safari.options'?: {
            [name: string]: any;
        };

        cleanSession?: boolean;

        // Chrome specific
        chromeOptions?: ChromeOptions;
        'goog:chromeOptions'?: ChromeOptions;
        mobileEmulationEnabled?: boolean;

        perfLoggingPrefs?: {
            enableNetwork?: boolean;
            enablePage?: boolean;
            enableTimeline?: boolean;
            tracingCategories?: boolean;
            bufferUsageReportingInterval?: boolean;
        };

        // wdio-sauce-service specific
        build?: string;

        // Appium General Capabilities
        automationName?: string;
        platformVersion?: string;
        deviceName?: string;
        app?: string;
        newCommandTimeout?: number;
        language?: string;
        locale?: string;
        udid?: string;
        orientation?: string;
        autoWebview?: boolean;
        noReset?: boolean;
        fullReset?: boolean;
        eventTimings?: boolean;
        enablePerformanceLogging?: boolean;
        printPageSourceOnFindFailure?: boolean;

        // Appium Android Only
        appActivity?: string;
        appPackage?: string;
        appWaitActivity?: string;
        appWaitPackage?: string;
        appWaitDuration?: number;
        deviceReadyTimeout?: number;
        allowTestPackages?: boolean;
        androidCoverage?: string;
        androidCoverageEndIntent?: string;
        androidDeviceReadyTimeout?: number;
        androidInstallTimeout?: number;
        androidInstallPath?: string;
        adbPort?: number;
        systemPort?: number;
        remoteAdbHost?: string;
        androidDeviceSocket?: string;
        avd?: string;
        avdLaunchTimeout?: number;
        avdReadyTimeout?: number;
        avdArgs?: string;
        useKeystore?: boolean;
        keystorePath?: string;
        keystorePassword?: string;
        keyAlias?: string;
        keyPassword?: string;
        chromedriverExecutable?: string;
        chromedriverArgs?: string[];
        chromedriverExecutableDir?: string;
        chromedriverChromeMappingFile?: string;
        chromedriverUseSystemExecutable?: boolean;
        autoWebviewTimeout?: number;
        chromedriverPort?: number;
        chromedriverPorts?: (number | number[])[]
        intentAction?: string;
        intentCategory?: string;
        intentFlags?: string;
        optionalIntentArguments?: string;
        dontStopAppOnReset?: boolean;
        unicodeKeyboard?: boolean;
        resetKeyboard?: boolean;
        noSign?: boolean;
        ignoreUnimportantViews?: boolean;
        disableAndroidWatchers?: boolean;
        recreateChromeDriverSessions?: boolean;
        nativeWebScreenshot?: boolean;
        androidScreenshotPath?: string;
        autoGrantPermissions?: boolean;
        networkSpeed?: string;
        gpsEnabled?: boolean;
        isHeadless?: boolean;
        adbExecTimeout?: number;
        localeScript?: string;
        skipDeviceInitialization?: boolean;
        chromedriverDisableBuildCheck?: boolean;
        skipUnlock?: boolean;
        unlockType?: string;
        unlockKey?: string;
        autoLaunch?: boolean;
        skipLogcatCapture?: boolean;
        uninstallOtherPackages?: string;
        disableWindowAnimation?: boolean;
        otherApps?: string;
        uiautomator2ServerLaunchTimeout?: number;
        uiautomator2ServerInstallTimeout?: number;
        skipServerInstallation?: boolean;
        espressoServerLaunchTimeout?: number;

        // Appium iOS Only
        calendarFormat?: string;
        bundleId?: string;
        launchTimeout?: number;
        locationServicesEnabled?: boolean;
        locationServicesAuthorized?: boolean;
        autoAcceptAlerts?: boolean;
        autoDismissAlerts?: boolean;
        nativeInstrumentsLib?: boolean;
        nativeWebTap?: boolean;
        safariInitialUrl?: string;
        safariAllowPopups?: boolean;
        safariIgnoreFraudWarning?: boolean;
        safariOpenLinksInBackground?: boolean;
        keepKeyChains?: boolean;
        localizableStringsDir?: string;
        processArguments?: string;
        interKeyDelay?: number;
        showIOSLog?: boolean;
        sendKeyStrategy?: string;
        screenshotWaitTimeout?: number;
        waitForAppScript?: string;
        webviewConnectRetries?: number;
        appName?: string;
        customSSLCert?: string;
        webkitResponseTimeout?: number;
        remoteDebugProxy?: string;
        enableAsyncExecuteFromHttps?: boolean;
        skipLogCapture?: boolean;
        webkitDebugProxyPort?: number;
    }

    interface Options {
        protocol?: string;
        hostname?: string;
        port?: number;
        path?: string;
        queryParams?: {
            [name: string]: string;
        },
        capabilities?: DesiredCapabilities;
        logLevel?: WebDriverLogTypes;
        logOutput?: string | NodeJS.WritableStream
        connectionRetryTimeout?: number;
        connectionRetryCount?: number;
        user?: string;
        key?: string;
    }

    interface AttachSessionOptions extends Options {
        sessionId: string,
        isW3C?: boolean
    }

    function newSession(
        options?: Options,
        modifier?: (...args: any[]) => any,
        proto?: object,
        commandWrapper?: (commandName: string, fn: (...args: any[]) => any) => any
    ): Promise<Client>;

    function attachToSession(
        options: AttachSessionOptions,
        modifier?: (...args: any[]) => any,
        proto?: object,
        commandWrapper?: (commandName: string, fn: (...args: any[]) => any) => any
    ): Promise<Client>;

    interface ClientOptions {
        capabilities: DesiredCapabilities;
        isW3C: boolean;
        isAndroid: boolean;
        isMobile: boolean;
        isIOS: boolean;
        sessionId: string;
    }

    // generated typings
        // webdriver types
    interface Client {
        newSession(capabilities: object): object;
        deleteSession(): void;
        status(): object;
        getTimeouts(): object;
        setTimeouts(implicit?: number, pageLoad?: number, script?: number): void;
        getUrl(): string;
        navigateTo(url: string): string;
        back(): void;
        forward(): void;
        refresh(): void;
        getTitle(): string;
        getWindowHandle(): string;
        closeWindow(): void;
        switchToWindow(handle: string): void;
        createWindow(type: string): object;
        getWindowHandles(): string[];
        switchToFrame(id: (number|string|object|null)): void;
        switchToParentFrame(): void;
        getWindowRect(): object;
        setWindowRect(x: (number|null), y: (number|null), width: (number|null), height: (number|null)): object;
        maximizeWindow(): object;
        minimizeWindow(): object;
        fullscreenWindow(): object;
        findElement(using: string, value: string): string;
        findElements(using: string, value: string): string[];
        findElementFromElement(using: string, value: string): string;
        findElementsFromElement(using: string, value: string): string[];
        getActiveElement(): string;
        isElementSelected(): boolean;
        isElementDisplayed(): boolean;
        getElementAttribute(name: string): string;
        getElementProperty(name: string): string;
        getElementCSSValue(propertyName: string): string;
        getElementText(): string;
        getElementTagName(): string;
        getElementRect(): object;
        isElementEnabled(): boolean;
        elementClick(): void;
        elementClear(): void;
        elementSendKeys(text: string, value?: string[]): void;
        getPageSource(): string;
        executeScript(script: string, args?: (string|object|number|boolean|undefined)[]): any;
        executeAsyncScript(script: string, args: (string|object|number|boolean|undefined)[]): any;
        getAllCookies(): object[];
        addCookie(cookie: object): void;
        deleteAllCookies(): void;
        getNamedCookie(name: string): object;
        deleteCookie(name: string): void;
        performActions(actions: object[]): void;
        releaseActions(): void;
        dismissAlert(): void;
        acceptAlert(): void;
        getAlertText(): string;
        sendAlertText(text: string): void;
        takeScreenshot(): string;
        takeElementScreenshot(scroll?: boolean): string;
    }

    // appium types
    interface Client {
        shake(): void;
        lock(seconds?: number): void;
        unlock(): void;
        isLocked(): boolean;
        startRecordingScreen(remotePath?: string, username?: string, password?: string, method?: string, forceRestart?: boolean, timeLimit?: string, videoType?: string, videoQuality?: string, videoFps?: string, bitRate?: string, videoSize?: string, bugReport?: string): void;
        stopRecordingScreen(remotePath?: string, username?: string, password?: string, method?: string): string;
        getPerformanceDataTypes(): string[];
        getPerformanceData(packageName: string, dataType: string, dataReadTimeout?: number): string[];
        pressKeyCode(keycode: number, metastate?: number, flags?: number): void;
        longPressKeyCode(keycode: number, metastate?: number, flags?: number): void;
        sendKeyEvent(keycode: string, metastate?: string): void;
        rotateDevice(x: number, y: number, radius: number, rotation: number, touchCount: number, duration: number, element?: string): void;
        getCurrentActivity(): string;
        getCurrentPackage(): string;
        installApp(appPath: string): void;
        activateApp(appId?: string, bundleId?: string): void;
        removeApp(appId?: string, bundleId?: string): void;
        terminateApp(appId?: string, bundleId?: string): void;
        isAppInstalled(appId?: string, bundleId?: string): boolean;
        queryAppState(appId?: string, bundleId?: string): number;
        hideKeyboard(strategy?: string, key?: string, keyCode?: string, keyName?: string): void;
        isKeyboardShown(): boolean;
        pushFile(path: string, data: string): void;
        pullFile(path: string): void;
        pullFolder(path: string): void;
        toggleAirplaneMode(): void;
        toggleData(): void;
        toggleWiFi(): void;
        toggleLocationServices(): void;
        openNotifications(): void;
        startActivity(appPackage: string, appActivity: string, appWaitPackage?: string, appWaitActivity?: string, intentAction?: string, intentCategory?: string, intentFlags?: string, optionalIntentArguments?: string, dontStopAppOnReset?: string): void;
        getSystemBars(): object[];
        getDeviceTime(): string;
        getDisplayDensity(): any;
        touchId(match: boolean): void;
        toggleEnrollTouchId(enabled?: boolean): void;
        launchApp(): void;
        closeApp(): void;
        reset(): void;
        background(seconds: (number|null)): void;
        endCoverage(intent: string, path: string): void;
        getStrings(language?: string, stringFile?: string): object;
        setValueImmediate(value: string): void;
        replaceValue(value: string): void;
        getSettings(): object;
        updateSettings(settings: object): void;
        receiveAsyncResponse(response: object): void;
        gsmCall(phoneNumber: string, action: string): void;
        gsmSignal(signalStrength: string, signalStrengh?: string): void;
        powerCapacity(percent: number): void;
        powerAC(state: string): void;
        gsmVoice(state: string): void;
        sendSms(phoneNumber: string, message: string): void;
        fingerPrint(fingerprintId: number): void;
        setClipboard(content: string, contentType?: string, label?: string): string;
        getClipboard(contentType?: string): string;
        touchPerform(actions: object[]): void;
        multiTouchPerform(actions: object[]): void;
    }

    // jsonwp types
    interface Client {
        status(): object;
        newSession(desiredCapabilities: object, requiredCapabilities: object): object;
        getSessions(): object[];
        getSession(): object;
        deleteSession(): void;
        setTimeouts(type: string, ms: number): void;
        setAsyncTimeout(ms: number): void;
        setImplicitTimeout(ms: number): void;
        getUrl(): string;
        navigateTo(url: string): void;
        back(): void;
        forward(): void;
        refresh(): void;
        getTitle(): string;
        getWindowHandle(): string;
        getWindowHandles(): string[];
        closeWindow(): void;
        switchToWindow(name: string): void;
        switchToFrame(id: (string|number|object|null)): void;
        switchToParentFrame(): void;
        getWindowPosition(): object;
        setWindowPosition(x: number, y: number): object;
        _getWindowSize(): object;
        _setWindowSize(width: number, height: number): void;
        maximizeWindow(): void;
        findElement(using: string, value: string): string;
        findElements(using: string, value: string): string[];
        findElementFromElement(using: string, value: string): string;
        findElementsFromElement(using: string, value: string): string[];
        getActiveElement(): string;
        isElementSelected(): boolean;
        isElementDisplayed(): boolean;
        getElementAttribute(name: string): string|null;
        getElementCSSValue(propertyName: string): string;
        getElementText(): string;
        getElementTagName(): string;
        getElementLocation(): object;
        getElementLocationInView(): object;
        getElementSize(): object;
        isElementEnabled(): boolean;
        elementClick(): void;
        elementEquals(otherElementId: string): boolean;
        elementSubmit(): void;
        elementClear(): void;
        elementSendKeys(value: string[]): void;
        sendKeys(value: string[]): void;
        getPageSource(): string;
        executeScript(script: string, args?: (string|object|number|boolean|undefined)[]): any;
        executeAsyncScript(script: string, args: (string|object|number|boolean|undefined)[]): any;
        getAllCookies(): object[];
        addCookie(cookie: object): void;
        deleteAllCookies(): void;
        deleteCookie(name: string): void;
        dismissAlert(): void;
        acceptAlert(): void;
        getAlertText(): string;
        sendAlertText(text: string): void;
        takeScreenshot(): string;
        getAvailableEngines(): string[];
        getActiveEngine(): string;
        isIMEActivated(): boolean;
        deactivateIME(): void;
        activateIME(engine: string): void;
        getOrientation(): string;
        setOrientation(orientation: string): void;
        moveToElement(element?: (string|null), xoffset?: number, yoffset?: number): void;
        buttonDown(button?: number): void;
        buttonUp(button?: number): void;
        positionClick(button?: number): void;
        positionDoubleClick(): void;
        touchClick(element: string): void;
        touchDown(x: number, y: number): void;
        touchUp(x: number, y: number): void;
        touchMove(x: number, y: number): void;
        touchScroll(xoffset: number, yoffset: number, element?: string): void;
        touchDoubleClick(element: string): void;
        touchLongClick(element: string): void;
        touchFlick(xoffset?: number, yoffset?: number, element?: string, speed?: number, xspeed?: number, yspeed?: number): void;
        getGeoLocation(): object;
        setGeoLocation(location: object): void;
        getLocalStorage(): string[];
        setLocalStorage(key: string, value: string): void;
        clearLocalStorage(): void;
        getLocalStorageItem(key: string): string;
        deleteLocalStorageItem(key: string): void;
        getLocalStorageSize(): number;
        getSessionStorage(): string[];
        setSessionStorage(key: string, value: string): void;
        clearSessionStorage(): void;
        getSessionStorageItem(key: string): string;
        deleteSessionStorageItem(key: string): void;
        getSessionStorageSize(): number;
        getLogs(type: string): object[];
        getLogTypes(): string[];
        getApplicationCacheStatus(): number;
    }

    // mjsonwp types
    interface Client {
        getContext(): string|null;
        switchContext(name: string): void;
        getContexts(): string[];
        getPageIndex(): string;
        getNetworkConnection(): number;
        setNetworkConnection(type: number): void;
        touchPerform(actions: object[]): void;
        multiTouchPerform(actions: object[], elementId: object[]): void;
        receiveAsyncResponse(status: string, value: string): void;
    }

    // chromium types
    interface Client {
        isAlertOpen(): boolean;
        isAutoReporting(): boolean;
        setAutoReporting(enabled: boolean): object|null;
        isLoading(): boolean;
        takeHeapSnapshot(): object;
        getNetworkConnection(): number;
        setNetworkConnection(parameters: object): number;
        getNetworkConditions(): object;
        setNetworkConditions(network_conditions: object, network_name?: string): void;
        deleteNetworkConditions(): void;
        sendCommand(cmd: string, params: object): void;
        sendCommandAndGetResult(cmd: string, params: object): any;
        generateTestReport(message: string, group: string): void;
        uploadFile(file: string): string;
        launchApp(id: string): void;
        getElementValue(): string|null;
        elementHover(): void;
        touchPinch(x: number, y: number, scale: number): void;
        freeze(): void;
        resume(): void;
        shutdown(): void;
        takeElementScreenshot(scroll?: boolean): string;
    }

    // saucelabs types
    interface Client {
        getPageLogs(type: string): object;
        throttleNetwork(condition: (string|object)): void;
        interceptRequest(rule: object): void;
        assertPerformance(name: string, metrics?: string[]): boolean;
    }


    interface ClientAsync extends AsyncClient { }
}

type AsyncClient = {
    [K in keyof WebDriver.Client]:
    (...args: Parameters<WebDriver.Client[K]>) => Promise<ReturnType<WebDriver.Client[K]>>;
}

declare module "webdriver" {
    export = WebDriver;
}
