"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ts = require("typescript");
function canNotBeUndefined(node) {
    return !(node !== undefined && (node.questionToken !== undefined || isUndefinedInDomainOf(node.type)));
}
exports.canNotBeUndefined = canNotBeUndefined;
function findConstructor(collection) {
    for (const item of collection) {
        if (item.kind === ts.SyntaxKind.Constructor) {
            return item;
        }
    }
    return undefined;
}
exports.findConstructor = findConstructor;
function isUndefinedInDomainOf(type) {
    if (type === undefined) {
        return false;
    }
    if ([ts.SyntaxKind.UnionType, ts.SyntaxKind.IntersectionType].indexOf(type.kind) !== -1) {
        const unionOrIntersection = type;
        return unionOrIntersection.types.some(isUndefinedInDomainOf);
    }
    return [ts.SyntaxKind.UndefinedKeyword].indexOf(type.kind) !== -1;
}
exports.isUndefinedInDomainOf = isUndefinedInDomainOf;
function isDeclaredInForStatement(node) {
    if (node.parent !== undefined
        && (node.parent.kind === ts.SyntaxKind.VariableDeclarationList)
        && (node.parent.parent !== undefined)) {
        const n = node.parent.parent;
        return n.kind === ts.SyntaxKind.ForStatement
            || n.kind === ts.SyntaxKind.ForInStatement
            || n.kind === ts.SyntaxKind.ForOfStatement;
    }
    return false;
}
exports.isDeclaredInForStatement = isDeclaredInForStatement;
function isDeclaredInCatch(node) {
    if (node.parent !== undefined
        && (node.parent.kind === ts.SyntaxKind.CatchClause)) {
        return true;
    }
    return false;
}
exports.isDeclaredInCatch = isDeclaredInCatch;
//# sourceMappingURL=Helpers.js.map