# tslint-react-recommended

Preset of rules for React & TypeScript development. Created to help developers write clean code and not to worry about TSLint configuration.

## Installation

`tslint-react-recommended` has implicit peer dependencies on [tslint](https://palantir.github.io/tslint/ "tslint") (version 5.0.0 or higher), [typscript](https://www.typescriptlang.org/ "typscript") (version 2.1.0-dev or higher), [tslint-react](https://github.com/palantir/tslint-react "tslint-react") (version 3.0.0 or higher) and [tslint-eslint-rules](https://github.com/buzinas/tslint-eslint-rules "tslint-eslint-rules") (version 4.0.0 ot higher). So you should install it in case of using this preset.

To install this package execute following commands.

&bull;  in case of using [Yarn](https://yarnpkg.com/lang/en/ "Yarn"): *(recommended)*
```console
yarn add tslint-react-recommended --dev
```

&bull;  in case of using npm:
```console
npm install tslint-react-recommended --save-dev
```

## Usage

To use these this preset, use configuration inheritance via the extends keyword. Here's a sample configuration where tslint.json lives adjacent to your node_modules folder:

```
{
	"extends": ["tslint-react-recommended"],
	"rules": {
		// if you want to make some adjustments
		// you can override preset rules here
	}
}
```

## Essentials to know

- No omission of curly braces, curly braces should be on the same line with code;
- **2 space** intendation;
- **LF** end of line;
- **const** whenever possible;
- No trailing spaces and commas;
- No parens for one-agrument lambdas;
- Specify return and parameter types whenver possible (except lambdas).

### Just a tip

I prefer to use [this package](https://github.com/ajafff/tslint-consistent-codestyle "this package") to set rules for naming variables, classes, etc. instead of `variable-name` rule. So I disabled `variable-name` to prevent rule collisions.

You can decide what to use in your project. **Good luck!**
