name: gettingstarted
category: testrunner
tags: guide
index: 0
title: WebdriverIO - Test Runner
---

Getting Started
===============

WebdriverIO comes with its own test runner to help you get started with integration testing as quickly as possible. All the fiddling around hooking up WebdriverIO with a test framework belongs to the past. The WebdriverIO runner does all the work for you and helps you to run your tests as efficiently as possible.

To see the command line interface help just type the following command in your terminal:

```txt
$ ./node_modules/.bin/wdio --help

WebdriverIO CLI runner

Usage: wdio [options] [configFile]
config file defaults to wdio.conf.js
The [options] object will override values from the config file.
An optional list of spec files can be piped to wdio that will override configured specs.

Options:
  --help, -h            prints WebdriverIO help menu
  --version, -v         prints WebdriverIO version
  --host                Selenium server host address
  --port                Selenium server port
  --path                Selenium server path (default: /wd/hub)
  --user, -u            username if using a cloud service as Selenium backend
  --key, -k             corresponding access key to the user
  --watch               watch specs for changes
  --logLevel, -l        level of logging verbosity (default: silent)
  --coloredLogs, -c     if true enables colors for log output (default: true)
  --bail                stop test runner after specific amount of tests have failed (default: 0 - don't bail)
  --screenshotPath, -s  saves a screenshot to a given path if a command fails
  --baseUrl, -b         shorten url command calls by setting a base url
  --waitforTimeout, -w  timeout for all waitForXXX commands (default: 1000ms)
  --framework, -f       defines the framework (Mocha, Jasmine or Cucumber) to run the specs (default: mocha)
  --reporters, -r       reporters to print out the results on stdout
  --suite               runs the defined suite, can be combined with --spec
  --spec                runs a certain spec file, can be combined with --suite - overrides specs piped from stdin
  --stdin, -            reads specs from stdin (a single dash is the abbrevated version)
  --cucumberOpts.*      Cucumber options, see the full list options at https://github.com/webdriverio/wdio-cucumber-framework#cucumberopts-options
  --jasmineOpts.*       Jasmine options, see the full list options at https://github.com/webdriverio/wdio-jasmine-framework#jasminenodeopts-options
  --mochaOpts.*         Mocha options, see the full list options at http://mochajs.org
```

Sweet! Now you need to define a configuration file where all information about your tests, capabilities and settings are set. Switch over to the [Configuration File](/guide/testrunner/configurationfile.html) section to find out how that file should look like. With the `wdio` configuration helper it is super easy to generate your config file. Just run:

```sh
$ ./node_modules/.bin/wdio config
```

and it launches the helper utility. It will ask you questions depending on the answers you give. This way
you can generate your config file in less than a minute.

<div class="cliwindow" style="width: 92%">
![WDIO configuration utility](/images/config-utility.gif "WDIO configuration utility")
</div>

Once you have your configuration file set up you can start your
integration tests by calling:

```sh
$ ./node_modules/.bin/wdio wdio.conf.js
```

That's it! Now, you can access to the selenium instance via the global variable `browser`.

## Run the test runner programmatically

Instead of calling the wdio command you can also include the test runner as module and run in within any arbitrary environment. For that you need to require the launcher module (in `/node_modules/webdriverio/build/launcher`) the following way:

```js
var Launcher = require('webdriverio').Launcher;
```

After that you create an instance of the launcher and run the test. The Launcher class expects as parameter the url to the config file and accepts [certain](https://github.com/webdriverio/webdriverio/blob/973f23d8949dae8168e96b1b709e5b19241a373b/lib/cli.js#L51-L55) parameters that will overwrite the value in the config.

```js
var wdio = new Launcher(opts.configFile, opts);
wdio.run().then(function (code) {
    process.exit(code);
}, function (error) {
    console.error('Launcher failed to start the test', error.stacktrace);
    process.exit(1);
});
```

The run command returns a [Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise) that gets resolved if the test ran successful or failed or gets rejected if the launcher was not able to start run the tests.
