name: v4
category: getstarted
tags: guide
index: 4
title: WebdriverIO - What's new in WebdriverIO?
---

# What's new in WebdriverIO v4?

History has proven to us: no major version change without rewriting the whole code base. This time we have rewritten everything into ES2016 conforming JavaScript and we use Babel now to compile the code before pushing it to NPM. This allows us not only to specify a project wide code style using `ESLint`, it also sets an important milestone for the future development of WebdriverIO. One of the next big changes compared to v3 is that we split up the codebase into multiple packages. That means that all reporters and framework adaptations  have to be installed separately. Note: if you have installed WebdriverIO globally you also need to install these extra packages globally. The schema of the new package system is as follows:

#### Framework Adaptations
- example plugins: [wdio-mocha-framework](https://github.com/webdriverio/wdio-mocha-framework), [wdio-jasmine-framework](https://github.com/webdriverio/wdio-jasmine-framework), [wdio-cucumber-framework](https://github.com/webdriverio/wdio-cucumber-framework)
- use naming convention is `wdio-*-framework`
- use NPM keywords wdio-plugin, wdio-framework

#### Reporters
- example plugins: [wdio-dot-reporter](https://github.com/webdriverio/wdio-dot-reporter), [wdio-junit-reporter](https://github.com/webdriverio/wdio-junit-reporter), [wdio-allure-reporter](https://github.com/webdriverio/wdio-allure-reporter)
- use naming convention is `wdio-*-reporter`
- use NPM keywords wdio-plugin, wdio-reporter

#### Services
- example services: [wdio-sauce-service](https://github.com/webdriverio/wdio-sauce-service)
- use naming convention is `wdio-*-service`
- use NPM keywords wdio-plugin, wdio-service

We really appreciate every new plugin that gets developed and may help other people to run better tests. If you have created such a plugin make sure to create a pull request to our [configuration utility](https://github.com/webdriverio/webdriverio/blob/master/lib/cli.js#L13-L33) so your package will be suggested if someone runs the wdio configurator.

### It's all synchronous

One of the probably biggest changes is the way WebdriverIO handles async in the wdio testrunner now. Many developers that moved away from Java to run their e2e tests in Node.js struggled with async handling of commands in their test suites. Also beginners had to learn the concept of promises to properly build up reliable tests. This is now over. All commands now block the execution of the test process until they've resolved. No `then` calls have to be done anymore, we can just assign the direct response of the Selenium server to a variable, like:

```js
describe('webdriver.io page', function() {
    it('should have the right title', function () {
        browser.url('/');
        var title = browser.getTitle();
        assert.equal(title, 'WebdriverIO - WebDriver bindings for Node.js');
    });
});
```

WebdriverIO uses the popular [Fibers](https://www.npmjs.com/package/fibers) package which is a Node.js plugin and compatible with all operating systems and various Node.js versions. It is also used by other big projects like [Meteor](https://www.meteor.com/) and is pretty stable and in active development. If you have used generators in v3 you can easily upgrade to v4 by removing the asterisks in your spec definitions as well as all `yield` words in your tests (there is no support for generators in v4 anymore).

### New concept of services

One really exciting new feature is the concept of services. These are little add-ons that help you to simplify tests, manage your test suite and integrate results with all kinds of 3rd party integrations. As a showcase service we created the package `wdio-sauce-service` which is a service for running tests on Sauce Labs. Of course, you can run tests using Sauce without that service but using the package reduces overhead and makes the setup way easier. For example, it updates the job status automatically and comes with a [Sauce Connect](https://wiki.saucelabs.com/display/DOCS/Sauce+Connect) integration to securely run your local tests in the cloud. We hope that the community is building a lot more services and 3rd party integrations.

### Reliable test execution through retry mechanisms

It's a known issue that e2e tests are fragile and not always reliable. It's the job of WebdriverIO to tackle this problem and prevent flakes from happening. An annoying and common error is the so called stale element reference error in Selenium where the element you are requesting got re-rendered causing the driver to lose its connection to it. These errors used to happen in random locations in your tests suite and there was almost no way to prevent them. In v4 we have now implemented a retry mechanism that checks for that error and automatically reruns the command for you. This mechanism can also be used to prevent other common problems from happening and will be improved with the next couple of versions. It also appears that some users faced connection issues in their internal grid system. This is now also handled by WebdriverIO which as of v4 will automatically retry all failing requests to the Selenium server.

### Hook me up!

Hooks are an important instrument to get information about the running test process. In the new version we introduced a lot of new hooks that allow you to interfere with the test at any time. You can make async requests to 3rd party tools as well as log certain states to get a better overview about the system you are testing. These are all of the new hooks that were implemented: `beforeSession`, `beforeSuite`, `beforeHook`, `beforeTest`, `beforeCommand`, `afterCommand`, `afterTest`, `afterHook`, `afterSuite`, `afterSession`, `onError` and for Cucumber tests: `beforeFeature`, `beforeScenario`, `beforeStep`, `afterFeature`, `afterScenario`, `afterStep`. Each of these hooks will wait to continue with the test process until synchronous WebdriverIO commands have finished or the returning promise has been resolved.
