name: boilerplate
category: getstarted
tags: guide
index: 2
title: WebdriverIO - Boilerplate Projects
---

# Boilerplate Projects

Over the time our community has developed a bunch of boilerplate projects that can be used as inspiration to set up your own test suite.

## [amiya-pattnaik/webdriverIO-with-cucumberBDD](https://github.com/amiya-pattnaik/webdriverIO-with-cucumberBDD)

- Framework: Cucumber (v3.x)
- Features:
    - Page Objects Model uses with ES6 style class base approach and fully ES6 - ES8 support through Babel
    - Examples of multi selector option to query element with more than one selector at a time
    - Examples of headless browser execution using - PhantomJS and Chrome
    - Integration with BrowserStack
    - Support of read/write data from MS-Excel for easy test data management from external data sources with examples
    - Database support to any RDBMS (Oracle, MySql, TeraData, Vertica etc.), executing any queries / fetching result set etc. with examples for E2E testing
    - Multiple reporting (Spec, Junit, Allure, JSON), plus local view of Junit report(.html) format
    - Task manage through Grunt
    - Examples with demo app https://search.yahoo.com/  and http://www.phptravels.net, Chai assertion liberary (expect, assert, should)
    - Appium specific .config file for playback on mobile device. For one click Appium setup refer [appium-setup-made-easy-OSX](https://github.com/amiya-pattnaik/appium-setup-made-easy-OSX) 

## [amiya-pattnaik/webdriverIO-with-jasmineBDD](https://github.com/amiya-pattnaik/webdriverIO-with-jasmineBDD)

- Framework: Jasmine (v3.x)
- Features:
    - Page Objects Model uses with ES6 style class base approach and fully ES6 - ES8 support through Babel
    - Examples of multi selector option to query element with more than one selector at a time
    - Examples of headless browser execution using - PhantomJS and Chrome
    - Integration with BrowserStack
    - Support of read/write data from MS-Excel for easy test data management from external data sources with examples
    - Database support to any RDBMS (Oracle, MySql, TeraData, Vertica etc.), executing any queries / fetching result set etc. with examples for E2E testing
    - Multiple reporting (Spec, Junit, Allure, JSON), plus local view of Junit report(.html) format
    - Task manage through Grunt
    - Examples with demo app http://www.phptravels.net
    - Appium specific .config file for playback on mobile device. For one click Appium setup refer [appium-setup-made-easy-OSX](https://github.com/amiya-pattnaik/appium-setup-made-easy-OSX)

## [amiya-pattnaik/webdriverIO-with-mochaBDD](https://github.com/amiya-pattnaik/webdriverIO-with-mochaBDD)

- Framework: Mocha (v5.x)
- Features:
    - Page Objects Model uses with ES6 style class base approach and fully ES6 - ES8 support through Babel
    - Examples of multi selector option to query element with more than one selector at a time
    - Examples of headless browser execution using - PhantomJS and Chrome
    - Integration with BrowserStack
    - Support of read/write data from MS-Excel for easy test data management from external data sources with examples
    - Database support to any RDBMS (Oracle, MySql, TeraData, Vertica etc.), executing any queries / fetching result set etc. with examples for E2E testing
    - Multiple reporting (Spec, Junit, Allure, JSON, Mochawesome), plus local view of Junit report(.html) format and Mochawesome report
    - Task manage through Grunt
    - Examples with demo app http://www.phptravels.net, Chai assertion liberary (expect, assert, should)
    - Appium specific .config file for playback on mobile device. For one click Appium setup refer [appium-setup-made-easy-OSX](https://github.com/amiya-pattnaik/appium-setup-made-easy-OSX)

## [webdriverio/cucumber-boilerplate](https://github.com/webdriverio/cucumber-boilerplate)

Our very own boilerplate for Cucumber test suites. We created over 150 predefined step definitions for you so that you can start write feature files for your project right away.

- Framework: Cucumber
- Features:
    - over 150 predefined steps that cover almost everything you need
    - integration of WebdriverIO's Multiremote functionality
    - own demo app

## [saucelabs-sample-test-frameworks/JS-Mocha-WebdriverIO-Selenium](https://github.com/saucelabs-sample-test-frameworks/JS-Mocha-WebdriverIO-Selenium)

Simple boilerplate project that runs multiple browser on [SauceLabs](https://saucelabs.com/) in parallel.

- Framework: Mocha
- Features:
    - Page Object usage
    - Integration with [SauceLabs](https://saucelabs.com/)

## [jonyet/webdriverio-boilerplate](https://github.com/jonyet/webdriverio-boilerplate)

Designed to be quick to get you started without getting terribly complex, as well as to share examples of how one can leverage external node modules to work in conjunction with wdio specs.

- Framework: Mocha
- Features:
    - examples for using Visual Regression testing with WebdriverIO v4
    - cloud integration with [BrowserStack](https://www.browserstack.com/)
    - Page Objects usage

## [cognitom/webdriverio-examples](https://github.com/cognitom/webdriverio-examples)

Project with various examples to setup WebdriverIO with an internal grid and PhantomJS or using cloud services like [TestingBot](https://testingbot.com/).

- Framework: Mocha
- Features:
    - examples for the tunneling feature from TestingBot
    - standalone examples
    - simple demonstration of how to integrate PhantomJS as a service so no that no Java is required

## [michaelguild13/Selenium-WebdriverIO-Mocha-Chai-Sinon-Boilerplate](https://github.com/michaelguild13/Selenium-WebdriverIO-Mocha-Chai-Sinon-Boilerplate)

Enhance testing stack demonstration with Mocha and Chai allows you to write simple assertion using the [Chai](http://chaijs.com/) assertion library.

- Framework: Mocha
- Features:
    - Chai integration
    - Babel setup

## [dcypherthis/wdio-boilerplate-cucumber](https://github.com/dcypherthis/wdio-boilerplate-cucumber)

This project is an example of how to get started with WebdriverIO for Selenium testing in Node.js. It makes use of the Cucumber BDD framework and works with dot, junit, and allure reporters. It is ES6 friendly (via babel-register) and uses Grunt to manage tasks.

- Framework: Cucumber
- Features:
    - detailed documentation
    - runs tests in a [Docker](https://www.docker.com/) container
    - Babel setup

## [WillLuce/WebdriverIO_Typescript](https://github.com/WillLuce/WebdriverIO_Typescript)

This directory contains the WebdriverIO page object example written using TypeScript.

- Framework: Mocha
- Features:
    - examples of Page Object Model implementation
    - Intellisense

## [klamping/wdio-starter-kit](https://github.com/klamping/wdio-starter-kit)

Boilerplate repo for quick set up of WebdriverIO test scripts with TravisCI, Sauce Labs and Visual Regression Testing

- Framework: Mocha, Chai
- Features:
    - Login & Registration Tests, with Page Objects
    - Mocha
    - Chai with expect global
    - Chai WebdriverIO
    - Sauce Labs integration
    - Visual Regression Tests
    - Local notifications
    - ESLint using Semistandard style
    - WebdriverIO tuned Gitignore file
    
## [webdriverio/appium-boilerplate](https://github.com/webdriverio/appium-boilerplate/)

Boilerplate project to run Appium tests together with WebdriverIO for:

- iOS/Android Native Apps
- iOS/Android Hybrid Apps
- Android Chrome and iOS Safari browser

The boilerplate holds the following things
- Framework: Jasmine
- Features:
    - Configs for:
        - iOS and Android app
        - iOS and Android browsers
    - Helpers for:
        - WebView
        - Gestures
        - Native alerts
        - Pickers
     - Tests examples for:
        - WebView
        - Login
        - Forms
        - Swipe
        - Browsers
