'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _jsonStringifySafe = require('json-stringify-safe');

var _jsonStringifySafe2 = _interopRequireDefault(_jsonStringifySafe);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var OBJLENGTH = 10;
var ARRLENGTH = 10;
var STRINGLIMIT = 1000;
var STRINGTRUNCATE = 200;
var notBase64 = /[^A-Z0-9+/=]/i;

var sanitizeString = function sanitizeString(str) {
    if (!str) {
        return '';
    }

    return String(str).replace(/^.*\/([^/]+)\/?$/, '$1').replace(/\./g, '_').replace(/\s/g, '').toLowerCase();
};

/**
 * formats capability object into sanitized string for e.g.filenames
 * @param {Object} caps  Selenium capabilities
 */
var caps = function caps(_caps) {
    if (!_caps) {
        return '';
    }

    var result = void 0;

    /**
     * mobile caps
     */
    if (_caps.deviceName) {
        result = [sanitizeString(_caps.deviceName), sanitizeString(_caps.platformName), sanitizeString(_caps.platformVersion), sanitizeString(_caps.app)];
    } else {
        result = [sanitizeString(_caps.browserName), sanitizeString(_caps.version), sanitizeString(_caps.platform), sanitizeString(_caps.app)];
    }

    result = result.filter(function (n) {
        return n !== undefined && n !== '';
    });
    return result.join('.');
};

/**
 * formats arguments into string
 * @param  {Array} args arguments object
 */
var args = function args(_args) {
    if (!_args || !Array.isArray(_args)) {
        return '';
    }

    return _args.map(function (arg) {
        if (typeof arg === 'function' || typeof arg === 'string' && arg.indexOf('return (function') === 0) {
            return '<Function>';
        } else if (typeof arg === 'string') {
            return `"${arg}"`;
        } else if (Array.isArray(arg)) {
            return arg.join(', ');
        }

        return arg;
    }).join(', ');
};

var css = function css(value) {
    if (!value) {
        return value;
    }

    return value.trim().replace(/'/g, '').replace(/"/g, '').toLowerCase();
};

var isBase64 = function isBase64(str) {
    if (typeof str !== 'string') {
        return false;
    }

    var len = str.length;
    if (!len || len % 4 !== 0 || notBase64.test(str)) {
        return false;
    }

    var firstPaddingChar = str.indexOf('=');
    return firstPaddingChar === -1 || firstPaddingChar === len - 1 || firstPaddingChar === len - 2 && str[len - 1] === '=';
};

/**
 * Limit the length of an arbitrary variable of any type, suitable for being logged or displayed
 * @param  {Any} val Any variable
 * @return {Any}     Limited var of same type
 */
var limit = function limit(val) {
    if (!val) return val;

    // Ensure we're working with a copy
    val = JSON.parse((0, _jsonStringifySafe2.default)(val));

    switch (Object.prototype.toString.call(val)) {
        case '[object String]':
            if (val.length > 100 && isBase64(val)) {
                return `[base64] ${val.length} bytes`;
            }

            if (val.length > STRINGLIMIT) {
                return val.substr(0, STRINGTRUNCATE) + ` ... (${val.length - STRINGTRUNCATE} more bytes)`;
            }

            return val;
        case '[object Array]':
            var length = val.length;
            if (length > ARRLENGTH) {
                val = val.slice(0, ARRLENGTH);
                val.push(`(${length - ARRLENGTH} more items)`);
            }
            return val.map(limit);
        case '[object Object]':
            var keys = (0, _keys2.default)(val);
            var removed = [];
            for (var i = 0, l = keys.length; i < l; i++) {
                if (i < OBJLENGTH) {
                    val[keys[i]] = limit(val[keys[i]]);
                } else {
                    delete val[keys[i]];
                    removed.push(keys[i]);
                }
            }
            if (removed.length) {
                val._ = keys.length - OBJLENGTH + ' more keys: ' + (0, _stringify2.default)(removed);
            }
            return val;
    }
    return val;
};

exports.default = {
    css,
    args,
    caps,
    limit
};
module.exports = exports['default'];