'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _utilities = require('../helpers/utilities');

var BUTTON_ENUM = {
    left: 0,
    middle: 1,
    right: 2
};

var REQUEST_PATH_ENUM = {
    down: '/session/:sessionId/buttondown',
    press: '/session/:sessionId/click',
    up: '/session/:sessionId/buttonup'

    /**
     * call must be scoped to the webdriverio client
     */
};var handleMouseButtonProtocol = function handleMouseButtonProtocol(requestPath, button) {
    var _this = this;

    if (typeof button !== 'number') {
        button = BUTTON_ENUM[button || 'left'];
    }

    return this.requestHandler.create(requestPath, { button: button }).catch(function (err) {
        /**
         * jsonwire command not supported try webdriver endpoint
         */
        if ((0, _utilities.isUnknownCommand)(err)) {
            var actions = [{ type: 'pointerDown', button: button }, { type: 'pointerUp', button: button }];

            if (requestPath === REQUEST_PATH_ENUM['down']) {
                actions = [{ type: 'pointerDown', button: button }];
            } else if (requestPath === REQUEST_PATH_ENUM['up']) {
                actions = [{ type: 'pointerUp', button: button }];
            }

            return _this.actions([{
                type: 'pointer',
                id: 'mouse',
                parameters: { pointerType: 'mouse' },
                actions
            }]);
        }

        return err;
    });
};

exports.default = handleMouseButtonProtocol;
module.exports = exports['default'];