'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _ErrorHandler = require('../utils/ErrorHandler');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var setCookie = function setCookie(cookieObj) {
    var name = cookieObj.name;
    /*!
     * parameter check
     */

    if (typeof cookieObj !== 'object' || !name || typeof name !== 'string') {
        throw new _ErrorHandler.CommandError('Please specify a cookie object to set (see https://github.com/SeleniumHQ/selenium/wiki/JsonWireProtocol#cookie-json-object for documentation.');
    }

    return this.cookie('POST', (0, _assign2.default)({}, cookieObj, { name: encodeURIComponent(encodeURIComponent(name)) }));
}; /**
    *
    * Sets a [cookie](https://github.com/SeleniumHQ/selenium/wiki/JsonWireProtocol#cookie-json-object)
    * for current page. Make sure you are on the page that should receive the cookie. You can't set
    * a cookie for an arbitrary page without being on that page.
    *
    * <example>
       :setCookie.js
       it('should set a cookie for the page', function () {
           browser.url('/')
           browser.setCookie({name: 'test', value: '123'});
   
           var cookies = browser.getCookie();
           console.log(cookies); // outputs: [{ name: 'test', value: '123', domain: 'www.example.com' }]
       });
    * </example>
    *
    * @alias browser.setCookie
    * @param {Object} cookie cookie object
    * @param {String} cookie.name The name of the cookie
    * @param {String} cookie.value The cookie value
    * @param {String} cookie.path  (Optional) The cookie path
    * @param {String} cookie.domain  (Optional) The domain the cookie is visible to
    * @param {Boolean} cookie.secure (Optional) Whether the cookie is a secure cookie
    * @param {Boolean} cookie.httpOnly  (Optional) Whether the cookie is an httpOnly cookie
    * @param {Number} cookie.expiry  (Optional) When the cookie expires, specified in seconds since midnight, January 1, 1970 UTC
    * @uses protocol/cookie
    * @type cookie
    *
    */

exports.default = setCookie;
module.exports = exports['default'];