"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const stream = require("stream");
/**
 * Transform an iterable into a node readable stream.
 */
function iterableToStream(src, options = { encoding: 'utf8' }) {
    return new ReadableObservableStream(src, options);
}
exports.iterableToStream = iterableToStream;
class ReadableObservableStream extends stream.Readable {
    constructor(_source, options) {
        super(options);
        this._source = _source;
    }
    _read() {
        if (!this.iter) {
            this.iter = this._source[Symbol.iterator]();
        }
        let r = this.iter.next();
        while (!r.done && this.push(r.value)) {
            r = this.iter.next();
        }
        if (r.done) {
            // since it is possible for r.value to have something meaningful, we must check.
            if (r.value !== null && r.value !== undefined) {
                this.push(r.value);
            }
            this.push(null);
        }
    }
}
exports.default = iterableToStream;
//# sourceMappingURL=iterableToStream.js.map