export declare type Maybe<T> = T | undefined;
export interface IterableLike<T> {
    [Symbol.iterator](): Iterator<T> | IterableIterator<T>;
}
export interface Sequence<T> extends IterableLike<T> {
    next(): IteratorResult<T>;
    /** keep values where the fnFilter(t) returns true */
    filter(fnFilter: (t: T) => boolean): Sequence<T>;
    skip(n: number): Sequence<T>;
    take(n: number): Sequence<T>;
    concat(j: Iterable<T>): Sequence<T>;
    concatMap<U>(fn: (t: T) => Iterable<U>): Sequence<U>;
    /** map values from type T to type U */
    combine<U, V>(fn: (t: T, u?: U) => V, j: Iterable<U>): Sequence<V>;
    map<U>(fnMap: (t: T) => U): Sequence<U>;
    scan(fnReduce: (previousValue: T, currentValue: T, currentIndex: number) => T, initialValue?: T): Sequence<T>;
    scan<U>(fnReduce: (previousValue: U, currentValue: T, currentIndex: number) => U, initialValue: U): Sequence<U>;
    all(fnFilter: (t: T) => boolean): boolean;
    any(fnFilter: (t: T) => boolean): boolean;
    count(): number;
    first(fnFilter?: (t: T) => boolean, defaultValue?: T): Maybe<T>;
    first(fnFilter: (t: T) => boolean, defaultValue: T): T;
    forEach(fn: (t: T, index: number) => void): void;
    max(fnSelector?: (t: T) => T): Maybe<T>;
    max<U>(fnSelector: (t: T) => U): Maybe<T>;
    min(fnSelector?: (t: T) => T): Maybe<T>;
    min<U>(fnSelector: (t: T) => U): Maybe<T>;
    /** reduce function see Array.reduce */
    reduce(fnReduce: (previousValue: T, currentValue: T, currentIndex: number) => T): Maybe<T>;
    reduce<U>(fnReduce: (previousValue: U, currentValue: T, currentIndex: number) => U, initialValue: U): U;
    reduceToSequence<U, V extends GenIterable<U>>(fnReduce: (previousValue: V, currentValue: T, currentIndex: number) => V, initialValue: V): Sequence<U>;
    reduceToSequence<U>(fnReduce: (previousValue: GenIterable<U>, currentValue: T, currentIndex: number) => GenIterable<U>, initialValue: GenIterable<U>): Sequence<U>;
    toArray(): T[];
    toIterable(): IterableIterator<T>;
}
export interface GenIterable<T> extends IterableLike<T> {
}
export interface SequenceCreator<T> {
    (i: GenIterable<T>): Sequence<T>;
    fromObject: <U>(u: U) => Sequence<KeyValuePair<U>>;
}
export declare function genSequence<T>(i: () => GenIterable<T>): Sequence<T>;
export declare function genSequence<T>(i: GenIterable<T>): Sequence<T>;
export declare const GenSequence: {
    genSequence: typeof genSequence;
    sequenceFromRegExpMatch: typeof sequenceFromRegExpMatch;
    sequenceFromObject: typeof sequenceFromObject;
};
export declare function filter<T>(fnFilter: (t: T) => boolean, i: Iterable<T>): IterableIterator<T>;
export declare function skip<T>(n: number, i: Iterable<T>): IterableIterator<T>;
export declare function take<T>(n: number, i: Iterable<T>): IterableIterator<T>;
/**
 * Concat two iterables together
 */
export declare function concat<T>(i: Iterable<T>, j: Iterable<T>): IterableIterator<T>;
export declare function concatMap<T, U>(fn: (t: T) => Iterable<U>, i: Iterable<T>): IterableIterator<U>;
/**
 * Combine two iterables together using fnMap function.
 */
export declare function combine<T, U, V>(fnMap: (t: T, u?: U) => V, i: Iterable<T>, j: Iterable<U>): IterableIterator<V>;
/**
 * apply a mapping function to an Iterable.
 */
export declare function map<T, U>(fnMap: (t: T) => U): (i: Iterable<T>) => IterableIterator<U>;
export declare function map<T, U>(fnMap: (t: T) => U, i: Iterable<T>): IterableIterator<U>;
export declare function scan<T>(i: Iterable<T>, fnReduce: (prevValue: T, curValue: T, curIndex: number) => T): IterableIterator<T>;
export declare function scan<T>(i: Iterable<T>, fnReduce: (prevValue: T, curValue: T, curIndex: number) => T, initValue: T): IterableIterator<T>;
export declare function scan<T, U>(i: Iterable<T>, fnReduce: (prevValue: U, curValue: T, curIndex: number) => U, initValue: U): IterableIterator<U>;
export declare function all<T>(fn: (t: T) => boolean, i: Iterable<T>): boolean;
export declare function any<T>(fn: (t: T) => boolean, i: Iterable<T>): boolean;
export declare function count<T>(i: Iterable<T>): number;
export declare function first<T>(fn: (t: T) => boolean, defaultValue: T, i: Iterable<T>): T;
export declare function forEach<T>(fn: (t: T, index: number) => void, i: Iterable<T>): void;
export declare function max<T, U>(selector: (t: T) => U, i: Iterable<T>): Maybe<T>;
export declare function min<T, U>(selector: (t: T) => U, i: Iterable<T>): Maybe<T>;
export declare function reduce<T, U>(fnReduce: (prevValue: U, curValue: T, curIndex: number) => U, initialValue: U, i: Iterable<T>): U;
export declare function reduce<T>(fnReduce: (prevValue: T, curValue: T, curIndex: number) => T, initialValue: T, i: Iterable<T>): T;
export declare function reduce<T>(fnReduce: (prevValue: T, curValue: T, curIndex: number) => T, initialValue: Maybe<T>, i: Iterable<T>): Maybe<T>;
export declare function toIterator<T>(i: Iterable<T>): IterableIterator<T>;
/**
 * Convert an Iterator into an IterableIterator
 */
export declare function makeIterable<T>(i: Iterator<T>): IterableIterator<T>;
/**
 * Creates a scan function that can be used in a map function.
 */
export declare function scanMap<T>(accFn: (acc: T, value: T) => T, init?: T): ((value: T) => T);
export declare function scanMap<T, U>(accFn: (acc: U, value: T) => U, init: U): ((value: T) => U);
export declare type KeyValuePair<T> = [keyof T, T[keyof T]];
export declare function objectIterator<T>(t: T): IterableIterator<KeyValuePair<T>>;
export declare function objectToSequence<T>(t: T): Sequence<KeyValuePair<T>>;
export declare function sequenceFromObject<T>(t: T): Sequence<KeyValuePair<T>>;
export declare function sequenceFromRegExpMatch(pattern: RegExp, text: string): Sequence<RegExpExecArray>;
export default genSequence;
