/// <reference types="node" />
import * as minimatch from 'minimatch';
import * as cspell from 'cspell-lib';
import { TraceResult, CheckTextInfo } from 'cspell-lib';
export { TraceResult, IncludeExcludeFlag } from 'cspell-lib';
import { GlobMatcher } from 'cspell-glob';
export interface CSpellApplicationOptions extends BaseOptions {
    /**
     * Display verbose information
     */
    verbose?: boolean;
    /**
     * Show extensive output.
     */
    debug?: boolean;
    /**
     * a glob to exclude files from being checked.
     */
    exclude?: string;
    /**
     * Only report the words, no line numbers or file names.
     */
    wordsOnly?: boolean;
    /**
     * unique errors per file only.
     */
    unique?: boolean;
    /**
     * root directory, defaults to `cwd`
     */
    root?: string;
}
export interface TraceOptions extends BaseOptions {
}
export interface BaseOptions {
    config?: string;
    languageId?: string;
    local?: string;
}
export interface AppError extends NodeJS.ErrnoException {
}
export interface RunResult {
    files: number;
    filesWithIssues: Set<string>;
    issues: number;
}
export interface Issue extends cspell.TextDocumentOffset {
}
export interface GlobSrcInfo {
    matcher: GlobMatcher;
    source: string;
}
export declare type MessageType = 'Debug' | 'Info' | 'Progress';
export declare type MessageTypeLookup = {
    [key in MessageType]: key;
};
export declare const MessageTypes: MessageTypeLookup;
export interface MessageEmitter {
    (message: string, msgType: MessageType): void;
}
export interface DebugEmitter {
    (message: string): void;
}
export interface ErrorEmitter {
    (message: string, error: Error): Promise<void>;
}
export interface SpellingErrorEmitter {
    (issue: Issue): void;
}
export interface Emitters {
    issue: SpellingErrorEmitter;
    info: MessageEmitter;
    debug: DebugEmitter;
    error: ErrorEmitter;
}
export declare class CSpellApplicationConfiguration {
    readonly files: string[];
    readonly options: CSpellApplicationOptions;
    readonly emitters: Emitters;
    readonly info: MessageEmitter;
    readonly debug: DebugEmitter;
    readonly logIssue: SpellingErrorEmitter;
    readonly uniqueFilter: (issue: Issue) => boolean;
    readonly local: string;
    readonly configGlob: string;
    readonly configGlobOptions: minimatch.IOptions;
    readonly excludes: GlobSrcInfo[];
    readonly root: string;
    constructor(files: string[], options: CSpellApplicationOptions, emitters: Emitters);
}
export declare function lint(files: string[], options: CSpellApplicationOptions, emitters: Emitters): Promise<RunResult>;
export declare function trace(words: string[], options: TraceOptions): Promise<TraceResult[]>;
export interface CheckTextResult extends CheckTextInfo {
}
export declare function checkText(filename: string, options: BaseOptions): Promise<CheckTextResult>;
export declare function createInit(_: CSpellApplicationOptions): Promise<void>;
