"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JOIN_SEPARATOR = '+';
exports.WORD_SEPARATOR = ' ';
var CompoundWordsMethod;
(function (CompoundWordsMethod) {
    /**
     * Do not compound words.
     */
    CompoundWordsMethod[CompoundWordsMethod["NONE"] = 0] = "NONE";
    /**
     * Create word compounds separated by spaces.
     */
    CompoundWordsMethod[CompoundWordsMethod["SEPARATE_WORDS"] = 1] = "SEPARATE_WORDS";
    /**
     * Create word compounds without separation.
     */
    CompoundWordsMethod[CompoundWordsMethod["JOIN_WORDS"] = 2] = "JOIN_WORDS";
})(CompoundWordsMethod = exports.CompoundWordsMethod || (exports.CompoundWordsMethod = {}));
/**
 * Walks the Trie and yields a value at each node.
 * next(goDeeper: boolean):
 */
function* walker(root, compoundingMethod = CompoundWordsMethod.NONE) {
    const roots = {
        [CompoundWordsMethod.NONE]: [],
        [CompoundWordsMethod.JOIN_WORDS]: [[exports.JOIN_SEPARATOR, root]],
        [CompoundWordsMethod.SEPARATE_WORDS]: [[exports.WORD_SEPARATOR, root]],
    };
    function* children(n) {
        if (n.c) {
            yield* n.c;
        }
        if (n.f) {
            yield* roots[compoundingMethod];
        }
    }
    let depth = 0;
    const stack = [];
    stack[depth] = { t: '', c: children(root) };
    let ir;
    while (depth >= 0) {
        let baseText = stack[depth].t;
        while (!(ir = stack[depth].c.next()).done) {
            const [char, node] = ir.value;
            const text = baseText + char;
            const goDeeper = (yield { text, node, depth });
            if (goDeeper || goDeeper === undefined) {
                depth++;
                baseText = text;
                stack[depth] = { t: text, c: children(node) };
            }
        }
        depth -= 1;
    }
}
exports.walker = walker;
/**
 * Walks the Trie and yields a value at each node.
 * next(goDeeper: boolean):
 */
function* hintedWalker(root, compoundingMethod = CompoundWordsMethod.NONE, hint) {
    const roots = {
        [CompoundWordsMethod.NONE]: [],
        [CompoundWordsMethod.JOIN_WORDS]: [[exports.JOIN_SEPARATOR, root]],
        [CompoundWordsMethod.SEPARATE_WORDS]: [[exports.WORD_SEPARATOR, root]],
    };
    const hints = new Set(hint.slice(0, 5));
    function* children(n) {
        if (n.c) {
            // First yield the hints
            yield* [...hints].filter(a => n.c.has(a)).map(a => [a, n.c.get(a)]);
            // Then yield everything else.
            yield* [...n.c].filter(a => !hints.has(a[0]));
        }
        if (n.f) {
            yield* roots[compoundingMethod];
        }
    }
    let depth = 0;
    const stack = [];
    let baseText = '';
    stack[depth] = children(root);
    let ir;
    while (depth >= 0) {
        while (!(ir = stack[depth].next()).done) {
            const [char, node] = ir.value;
            const text = baseText + char;
            const hinting = (yield { text, node, depth });
            if (hinting && hinting.goDeeper) {
                depth++;
                baseText = text;
                stack[depth] = children(node);
            }
        }
        depth -= 1;
        baseText = baseText.slice(0, -1);
    }
}
exports.hintedWalker = hintedWalker;
//# sourceMappingURL=walker.js.map