import { TrieNode } from './TrieNode';
export declare const JOIN_SEPARATOR: string;
export declare const WORD_SEPARATOR: string;
export interface YieldResult {
    text: string;
    node: TrieNode;
    depth: number;
}
export declare enum CompoundWordsMethod {
    /**
     * Do not compound words.
     */
    NONE = 0,
    /**
     * Create word compounds separated by spaces.
     */
    SEPARATE_WORDS = 1,
    /**
     * Create word compounds without separation.
     */
    JOIN_WORDS = 2
}
export interface WalkerIterator extends IterableIterator<YieldResult> {
    /**
     * Ask for the next result.
     * goDeeper of true tells the walker to go deeper in the Trie if possible. Default is true.
     * This can be used to limit the walker's depth.
     */
    next: (goDeeper?: boolean) => IteratorResult<YieldResult>;
    [Symbol.iterator]: () => WalkerIterator;
}
/**
 * Walks the Trie and yields a value at each node.
 * next(goDeeper: boolean):
 */
export declare function walker(root: TrieNode, compoundingMethod?: CompoundWordsMethod): WalkerIterator;
export interface Hinting {
    goDeeper: boolean;
}
export interface HintedWalkerIterator extends IterableIterator<YieldResult> {
    /**
     * Ask for the next result.
     * goDeeper of true tells the walker to go deeper in the Trie if possible. Default is true.
     * This can be used to limit the walker's depth.
     */
    next: (hinting: Hinting) => IteratorResult<YieldResult>;
    [Symbol.iterator]: () => WalkerIterator;
}
/**
 * Walks the Trie and yields a value at each node.
 * next(goDeeper: boolean):
 */
export declare function hintedWalker(root: TrieNode, compoundingMethod: CompoundWordsMethod | undefined, hint: string): HintedWalkerIterator;
