import { Sequence } from 'gensequence';
import { TrieNode } from './TrieNode';
import { YieldResult } from './walker';
export { YieldResult } from './walker';
export declare function insert(text: string, node?: TrieNode): TrieNode;
export declare function isWordTerminationNode(node: TrieNode): boolean;
/**
 * Sorts the nodes in a trie in place.
 */
export declare function orderTrie(node: TrieNode): void;
/**
 * Generator an iterator that will walk the Trie parent then children in a depth first fashion that preserves sorted order.
 */
export declare function walk(node: TrieNode): Sequence<YieldResult>;
export declare const iterateTrie: typeof walk;
/**
 * Generate a Iterator that can walk a Trie and yield the words.
 */
export declare function iteratorTrieWords(node: TrieNode): Sequence<string>;
export declare function createRoot(): TrieNode;
export declare function createTriFromList(words: Iterable<string>): TrieNode;
export declare function has(node: TrieNode, word: string): boolean;
export declare function findNode(node: TrieNode, prefix: string): TrieNode | undefined;
