import { TrieNode } from './TrieNode';
import { CompoundWordsMethod } from './walker';
export { CompoundWordsMethod, JOIN_SEPARATOR, WORD_SEPARATOR } from './walker';
export declare type Cost = number;
export declare type MaxCost = Cost;
export interface SuggestionResult {
    word: string;
    cost: Cost;
}
export interface SuggestionIterator extends IterableIterator<SuggestionResult> {
    /**
     * Ask for the next result.
     * maxCost - sets the max cost for following suggestions
     * This is used to limit which suggestions are emitted.
     * If the iterator.next() returns `undefined`, it is to request a value for maxCost.
     */
    next: (maxCost?: MaxCost) => IteratorResult<SuggestionResult>;
    [Symbol.iterator]: () => SuggestionIterator;
}
export declare function suggest(root: TrieNode, word: string, maxNumSuggestions?: number, compoundMethod?: CompoundWordsMethod, numChanges?: number): SuggestionResult[];
export declare function genSuggestions(root: TrieNode, word: string, compoundMethod?: CompoundWordsMethod): SuggestionIterator;
export declare function genCompoundableSuggestions(root: TrieNode, word: string, compoundMethod: CompoundWordsMethod): SuggestionIterator;
export declare function compSuggestionResults(a: SuggestionResult, b: SuggestionResult): number;
export interface SuggestionCollector {
    collect: (src: SuggestionIterator) => void;
    add: (suggestion: SuggestionResult) => SuggestionCollector;
    readonly suggestions: SuggestionResult[];
    readonly maxCost: number;
    readonly word: string;
    readonly maxNumSuggestions: number;
}
export declare function suggestionCollector(wordToMatch: string, maxNumSuggestions: number, filter?: (word: string) => boolean, changeLimit?: number): SuggestionCollector;
