"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const intl = new Intl.Collator('en', { sensitivity: 'base' });
exports.compare = intl.compare;
exports.visualLetterGroups = [
    // cspell:disable
    '',
    'ǎàåÄÀAãâáǟặắấĀāăąaäæɐɑᾳαа',
    'Bbḃвъь',
    'ċČčcĉçCÇćĊСсς',
    'ḎḋḏḑďđḍDd',
    'ēëÈÊËềéèếệĕeEĒėęěêəɛёЁеʒ',
    'fḟF',
    'ġĠĞǧĝģGgɣ',
    'ħĦĥḥHhḤȟн',
    'IįïİÎÍīiÌìíîıɪɨї',
    'jJĵ',
    'ķKkκкќ',
    'ḷłľļLlĺḶίι',
    'Mṃṁm',
    'nņÑNṇňŇñńŋѝий',
    'ÒOøȭŌōőỏoÖòȱȯóôõöơɔόδо',
    'PṗpрРρ',
    'Qq',
    'řRṛrŕŗѓгя',
    'ṣšȘṢsSŠṡŞŝśșʃ',
    'tțȚťTṭṬṫ',
    'ÜüûŪưůūűúÛŭÙùuųU',
    'Vvν',
    'ŵwWẃẅẁωш',
    'xXх',
    'ÿýYŷyÝỳУўу',
    'ZẓžŽżŻźz',
];
exports.visualLetterMap = calcVisualLetterMap(exports.visualLetterGroups);
function calcVisualLetterMap(groups) {
    // map each letter in a group to the index of the group.
    const map = new Map();
    groups
        .map(g => g.split(''))
        .forEach((g, i) => g.forEach(c => map.set(c, i)));
    return map;
}
//# sourceMappingURL=orthography.js.map