import { TrieNode } from './TrieNode';
export declare class DawgChildMap extends Map<string, DawgTrieNode> {
}
export interface DawgTrieNode extends TrieNode {
    c?: DawgChildMap;
    id: number;
    hash: number;
}
export declare class DawgTrieBuilder {
    private hasher;
    protected nextId: number;
    protected nodes: Map<number, DawgTrieNode>;
    protected hashNodes: Map<number, Set<DawgTrieNode>>;
    protected leaf: DawgTrieNode;
    protected root: DawgTrieNode;
    constructor();
    readonly trie: DawgTrieNode;
    addWord(word: string): void;
    protected addToNode(curr: DawgTrieNode, s: string): DawgTrieNode;
    protected createNode(children: DawgChildMap): DawgTrieNode;
    protected hash(node: DawgTrieNode): number;
    protected rememberNode(n: DawgTrieNode): void;
    protected findHashMatch(n: DawgTrieNode): DawgTrieNode | undefined;
    protected isEquiv(a: DawgTrieNode, b: DawgTrieNode): boolean;
    static trieToString(r: DawgTrieNode): string;
    static hashToString(n: number): string;
}
