"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// cSpell:enableCompoundWords
const Text = require("./util/text");
const fileReader_1 = require("./util/fileReader");
const cspell_util_bundle_1 = require("cspell-util-bundle");
const iterableIteratorLib_1 = require("./util/iterableIteratorLib");
const regExpWordsWithSpaces = cspell_util_bundle_1.xregexp('^\\s*\\p{L}+(?:\\s+\\p{L}+){0,3}$');
/**
 * Reads words from a file. It will not throw and error.
 * @param filename the file to read
 */
function loadWordsNoError(filename) {
    return fileReader_1.readLines(filename).catch(e => (logError(e), iterableIteratorLib_1.toIterableIterator([])));
}
exports.loadWordsNoError = loadWordsNoError;
function logError(e) {
    console.log(e);
}
function splitLine(line) {
    return Text.extractWordsFromText(line).map(({ text }) => text).toArray();
}
exports.splitLine = splitLine;
function splitCodeWords(words) {
    return words
        .map(Text.splitCamelCaseWord)
        .reduce((a, b) => a.concat(b), []);
}
exports.splitCodeWords = splitCodeWords;
function splitLineIntoCodeWords(line) {
    const asMultiWord = regExpWordsWithSpaces.test(line) ? [line] : [];
    const asWords = splitLine(line);
    const splitWords = splitCodeWords(asWords);
    const wordsToAdd = new Set(iterableIteratorLib_1.concatIterables(asMultiWord, asWords, splitWords));
    return iterableIteratorLib_1.toIterableIterator(wordsToAdd);
}
exports.splitLineIntoCodeWords = splitLineIntoCodeWords;
function splitLineIntoWords(line) {
    const asWords = splitLine(line);
    return iterableIteratorLib_1.concatIterables([line], asWords);
}
exports.splitLineIntoWords = splitLineIntoWords;
//# sourceMappingURL=wordListHelper.js.map