"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Dictionary = require("./SpellingDictionary");
const Settings = require("./Settings");
exports.diagSource = 'cSpell Checker';
const TV = require("./textValidator");
function validateText(text, settings) {
    const finalSettings = Settings.finalizeSettings(settings);
    const dict = Dictionary.getDictionary(finalSettings);
    return dict.then(dict => [...TV.validateText(text, dict, finalSettings)]);
}
exports.validateText = validateText;
var IncludeExcludeFlag;
(function (IncludeExcludeFlag) {
    IncludeExcludeFlag["INCLUDE"] = "I";
    IncludeExcludeFlag["EXCLUDE"] = "E";
})(IncludeExcludeFlag = exports.IncludeExcludeFlag || (exports.IncludeExcludeFlag = {}));
async function checkText(text, settings) {
    const validationResult = validateText(text, settings);
    const finalSettings = Settings.finalizeSettings(settings);
    const includeRanges = TV.calcTextInclusionRanges(text, finalSettings);
    const result = [];
    let lastPos = 0;
    for (const { startPos, endPos } of includeRanges) {
        result.push({
            text: text.slice(lastPos, startPos),
            startPos: lastPos,
            endPos: startPos,
            flagIE: IncludeExcludeFlag.EXCLUDE,
        });
        result.push({
            text: text.slice(startPos, endPos),
            startPos,
            endPos,
            flagIE: IncludeExcludeFlag.INCLUDE,
        });
        lastPos = endPos;
    }
    result.push({
        text: text.slice(lastPos),
        startPos: lastPos,
        endPos: text.length,
        flagIE: IncludeExcludeFlag.EXCLUDE,
    });
    const issues = await validationResult;
    function* merge() {
        let i = 0;
        for (const r of result) {
            if (i >= issues.length || issues[i].offset >= r.endPos) {
                yield r;
                continue;
            }
            let span = Object.assign({}, r);
            while (i < issues.length && issues[i].offset < span.endPos) {
                const issue = issues[i];
                const endPos = issue.offset;
                const text = span.text.slice(0, endPos - span.startPos);
                const endPosError = issue.offset + issue.text.length;
                yield Object.assign({}, span, { text, endPos });
                yield Object.assign({}, span, { isError: true, startPos: issue.offset, endPos: endPosError, text: issue.text });
                span.text = span.text.slice(endPosError - span.startPos);
                span.startPos = endPosError;
                i += 1;
            }
            yield span;
        }
    }
    return {
        text,
        items: [...merge()].filter(i => i.startPos < i.endPos),
    };
}
exports.checkText = checkText;
//# sourceMappingURL=validator.js.map