"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cspell_io_1 = require("cspell-io");
const iterableIteratorLib_1 = require("./iterableIteratorLib");
async function readLines(filename, encoding = 'utf8') {
    try {
        const content = await cspell_io_1.readFile(filename, encoding);
        return iterableIteratorLib_1.toIterableIterator(content.split(/\r?\n/g));
    }
    catch (e) {
        return Promise.reject(e);
    }
}
exports.readLines = readLines;
//# sourceMappingURL=fileReader.js.map