"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const defaultSize = 50000;
function memorizer(fn, size = defaultSize) {
    const cache = new Map();
    return (...args) => {
        const key = args.join('>!@[');
        if (!cache.has(key)) {
            if (cache.size >= size) {
                cache.clear();
            }
            cache.set(key, fn(...args));
        }
        return cache.get(key);
    };
}
exports.memorizer = memorizer;
//# sourceMappingURL=Memorizer.js.map