export declare type Comparable = number | string | boolean | undefined | null | Date;
export declare type ComparableFilter<T> = T extends Comparable ? T : never;
export declare type ComparablePropertyNames<T> = {
    [K in keyof T]: T[K] extends Comparable ? K : never;
}[keyof T];
export declare type ComparableProperties<T> = Pick<T, ComparablePropertyNames<T>>;
export declare type CompareArg<T> = ComparablePropertyNames<T> | ((t: T) => Comparable);
export declare type CompareFn<T> = (a: T, b: T) => number;
export declare function compareBy<T>(extract: CompareArg<T>, ...extractors: CompareArg<T>[]): CompareFn<T>;
export declare function compareBy<T>(extract: CompareArg<T>): CompareFn<T>;
export declare function compareBy<T>(extract1: CompareArg<T>, extract2: CompareArg<T>): CompareFn<T>;
export declare function compareBy<T>(extract1: CompareArg<T>, extract2: CompareArg<T>, extract3: CompareArg<T>): CompareFn<T>;
export declare function compareByRev<T>(extract: CompareArg<T>, ...extractors: CompareArg<T>[]): CompareFn<T>;
export declare function compareByRev<T>(extract: CompareArg<T>): CompareFn<T>;
export declare function compareByRev<T>(extract1: CompareArg<T>, extract2: CompareArg<T>): CompareFn<T>;
export declare function compareByRev<T>(extract1: CompareArg<T>, extract2: CompareArg<T>, extract3: CompareArg<T>): CompareFn<T>;
export declare function compareEach<T>(...compareFn: CompareFn<T>[]): CompareFn<T>;
export declare function compare<T>(a: ComparableFilter<T>, b: ComparableFilter<T>): number;
export declare function reverse<T>(fn: CompareFn<T>): CompareFn<T>;
