"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Settings_1 = require("./Settings");
const SpellingDictionary_1 = require("./SpellingDictionary");
const util = require("./util/util");
const gensequence_1 = require("gensequence");
async function traceWords(words, settings) {
    const r = await Promise.all(gensequence_1.genSequence(words)
        // Combine the words with the configs
        .map(word => ({ word, config: settings }))
        // Load the dictionaries
        .map(async ({ word, config }) => {
        const settings = Settings_1.finalizeSettings(config);
        const dictionaries = (settings.dictionaries || [])
            .concat((settings.dictionaryDefinitions || []).map(d => d.name))
            .filter(util.uniqueFn);
        const dictSettings = Object.assign({}, settings, { dictionaries });
        const dicts = await SpellingDictionary_1.getDictionary(dictSettings);
        return { word, config, dicts };
    })
        .toArray());
    // Search each dictionary for the word
    const s = gensequence_1.genSequence(r).concatMap(p => {
        const { word, config, dicts } = p;
        return dicts.dictionaries.map(dict => ({
            word,
            found: dict.has(word),
            dictName: dict.name,
            dictSource: dict.source,
            configSource: config.name || '',
        }));
    }).toArray();
    return s;
}
exports.traceWords = traceWords;
//# sourceMappingURL=trace.js.map