"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const vscode_uri_1 = require("vscode-uri");
const minimatch = require("minimatch");
const separator = '/';
const defaultAllowedSchemes = new Set(['file', 'untitled']);
function extractGlobsFromExcludeFilesGlobMap(globMap) {
    const globs = Object.getOwnPropertyNames(globMap)
        .filter(glob => globMap[glob]);
    return globs;
}
exports.extractGlobsFromExcludeFilesGlobMap = extractGlobsFromExcludeFilesGlobMap;
function pathToUri(filePath) {
    return vscode_uri_1.URI.file(filePath);
}
exports.pathToUri = pathToUri;
function generateExclusionFunctionForUri(globs, root, allowedSchemes = defaultAllowedSchemes) {
    const rootUri = pathToUri(root || '/');
    const fns = globs.map(glob => minimatch.filter(glob, { matchBase: true }));
    function testPath(path) {
        return fns.reduce((prev, fn, idx) => prev || fn(path, idx, [path]), false);
    }
    function testPathStepByStep(path) {
        const parts = path.split(separator);
        for (let i = 0; i < parts.length; ++i) {
            const p = parts.slice(0, i + 1).join(separator);
            if (testPath(p)) {
                return true;
            }
        }
        return false;
    }
    function testUri(uri) {
        if (!allowedSchemes.has(uri.scheme)) {
            return true;
        }
        const relativeRoot = uri.path.slice(0, rootUri.path.length);
        if (relativeRoot === rootUri.path) {
            const relativeToRoot = uri.path.slice(rootUri.path.length);
            return testPathStepByStep(relativeToRoot);
        }
        // the uri is not relative to the root.
        return testPathStepByStep(uri.path);
    }
    function testUriPath(uriPath) {
        const uri = vscode_uri_1.URI.parse(uriPath);
        return testUri(uri);
    }
    return testUriPath;
}
exports.generateExclusionFunctionForUri = generateExclusionFunctionForUri;
//# sourceMappingURL=exclusionHelper.js.map