"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const SpellingDictionary_1 = require("./SpellingDictionary");
const gensequence_1 = require("gensequence");
const Settings_1 = require("../Settings");
class SpellingDictionaryCollection {
    constructor(dictionaries, name, wordsToFlag) {
        this.dictionaries = dictionaries;
        this.name = name;
        this.options = {};
        this.mapWord = (word) => word;
        this.type = 'SpellingDictionaryCollection';
        this.dictionaries = this.dictionaries.filter(a => !!a.size).sort((a, b) => b.size - a.size);
        this.wordsToFlag = new Set(wordsToFlag.map(w => w.toLowerCase()));
        this.source = dictionaries.map(d => d.name).join(', ');
        this.isDictionaryCaseSensitive = this.dictionaries.reduce((a, b) => a || b.isDictionaryCaseSensitive, false);
    }
    has(word, hasOptions) {
        const options = SpellingDictionary_1.hasOptionToSearchOption(hasOptions);
        return !this.wordsToFlag.has(word.toLowerCase()) && isWordInAnyDictionary(this.dictionaries, word, options);
    }
    suggest(...args) {
        const [word, options, compoundMethod, numChanges] = args;
        const suggestOptions = (typeof options === 'object')
            ? options
            : {
                numSuggestions: options,
                compoundMethod,
                numChanges
            };
        return this._suggest(word, suggestOptions);
    }
    _suggest(word, suggestOptions) {
        const _suggestOptions = Object.assign({}, suggestOptions);
        const { numSuggestions = Settings_1.getDefaultSettings().numSuggestions || SpellingDictionary_1.defaultNumSuggestions, numChanges, compoundMethod, ignoreCase = true, } = suggestOptions;
        _suggestOptions.compoundMethod = this.options.useCompounds ? SpellingDictionary_1.CompoundWordsMethod.JOIN_WORDS : compoundMethod;
        const filter = (word) => {
            return !this.wordsToFlag.has(word.toLowerCase())
                && (ignoreCase || word[0] !== SpellingDictionary_1.PREFIX_NO_CASE);
        };
        const collector = SpellingDictionary_1.suggestionCollector(word, numSuggestions, filter, numChanges);
        this.genSuggestions(collector, suggestOptions);
        return collector.suggestions.map(r => (Object.assign({}, r, { word: r.word.replace(SpellingDictionary_1.regexPrefix, '') })));
    }
    get size() {
        return this.dictionaries.reduce((a, b) => a + b.size, 0);
    }
    genSuggestions(collector, suggestOptions) {
        const _suggestOptions = Object.assign({}, suggestOptions);
        const { compoundMethod = SpellingDictionary_1.CompoundWordsMethod.SEPARATE_WORDS } = suggestOptions;
        _suggestOptions.compoundMethod = this.options.useCompounds ? SpellingDictionary_1.CompoundWordsMethod.JOIN_WORDS : compoundMethod;
        this.dictionaries.forEach(dict => dict.genSuggestions(collector, _suggestOptions));
    }
}
exports.SpellingDictionaryCollection = SpellingDictionaryCollection;
function createCollection(dictionaries, name, wordsToFlag = []) {
    return new SpellingDictionaryCollection(dictionaries, name, wordsToFlag);
}
exports.createCollection = createCollection;
function isWordInAnyDictionary(dicts, word, options) {
    return !!gensequence_1.genSequence(dicts)
        .first(dict => dict.has(word, options));
}
exports.isWordInAnyDictionary = isWordInAnyDictionary;
function createCollectionP(dicts, name, wordsToFlag) {
    return Promise.all(dicts)
        .then(dicts => new SpellingDictionaryCollection(dicts, name, wordsToFlag));
}
exports.createCollectionP = createCollectionP;
//# sourceMappingURL=SpellingDictionaryCollection.js.map