import { CompoundWordsMethod, SpellingDictionary, SpellingDictionaryOptions, SuggestionCollector, SuggestionResult, HasOptions, SearchOptions, SuggestOptions } from './SpellingDictionary';
export declare class SpellingDictionaryCollection implements SpellingDictionary {
    readonly dictionaries: SpellingDictionary[];
    readonly name: string;
    readonly options: SpellingDictionaryOptions;
    readonly mapWord: (word: string) => string;
    readonly wordsToFlag: Set<string>;
    readonly type = "SpellingDictionaryCollection";
    readonly source: string;
    readonly isDictionaryCaseSensitive: boolean;
    constructor(dictionaries: SpellingDictionary[], name: string, wordsToFlag: string[]);
    has(word: string, hasOptions?: HasOptions): boolean;
    suggest(word: string, numSuggestions?: number, compoundMethod?: CompoundWordsMethod, numChanges?: number): SuggestionResult[];
    suggest(word: string, suggestOptions: SuggestOptions): SuggestionResult[];
    _suggest(word: string, suggestOptions: SuggestOptions): SuggestionResult[];
    readonly size: number;
    genSuggestions(collector: SuggestionCollector, suggestOptions: SuggestOptions): void;
}
export declare function createCollection(dictionaries: SpellingDictionary[], name: string, wordsToFlag?: string[]): SpellingDictionaryCollection;
export declare function isWordInAnyDictionary(dicts: SpellingDictionary[], word: string, options: SearchOptions): boolean;
export declare function createCollectionP(dicts: (Promise<SpellingDictionary> | SpellingDictionary)[], name: string, wordsToFlag: string[]): Promise<SpellingDictionaryCollection>;
