import { IterableLike } from '../util/IterableLike';
import { Trie, SuggestionCollector, SuggestionResult, CompoundWordsMethod } from 'cspell-trie-lib';
import { ReplaceMap } from '../Settings';
import { FunctionArgs } from '../util/types';
export { CompoundWordsMethod, JOIN_SEPARATOR, SuggestionCollector, suggestionCollector, SuggestionResult, WORD_SEPARATOR, } from 'cspell-trie-lib';
export declare type FilterSuggestionsPredicate = (word: SuggestionResult) => boolean;
export declare const PREFIX_NO_CASE = ">";
export declare const regexPrefix: RegExp;
export interface SearchOptions {
    useCompounds?: boolean | number;
    ignoreCase?: boolean;
}
export interface SuggestOptions {
    compoundMethod?: CompoundWordsMethod;
    numSuggestions?: number;
    numChanges?: number;
    ignoreCase?: boolean;
}
export declare type HasOptions = boolean | SearchOptions;
export interface SpellingDictionary {
    readonly name: string;
    readonly type: string;
    readonly source: string;
    has(word: string, useCompounds: boolean): boolean;
    has(word: string, options: HasOptions): boolean;
    has(word: string, options?: HasOptions): boolean;
    suggest(word: string, numSuggestions?: number, compoundMethod?: CompoundWordsMethod, numChanges?: number): SuggestionResult[];
    suggest(word: string, suggestOptions: SuggestOptions): SuggestionResult[];
    genSuggestions(collector: SuggestionCollector, suggestOptions: SuggestOptions): void;
    mapWord(word: string): string;
    readonly size: number;
    readonly options: SpellingDictionaryOptions;
    readonly isDictionaryCaseSensitive: boolean;
}
export declare type SuggestArgs = FunctionArgs<SpellingDictionary['suggest']> | FunctionArgs<(word: string, numSuggestions?: number, compoundMethod?: CompoundWordsMethod, numChanges?: number) => SuggestionResult[]>;
export interface SpellingDictionaryOptions {
    repMap?: ReplaceMap;
    useCompounds?: boolean;
    caseSensitive?: boolean;
}
export declare const defaultNumSuggestions = 10;
export declare function createSpellingDictionary(wordList: string[] | IterableLike<string>, name: string, source: string, options?: SpellingDictionaryOptions): SpellingDictionary;
export declare class SpellingDictionaryFromTrie implements SpellingDictionary {
    readonly trie: Trie;
    readonly name: string;
    readonly options: SpellingDictionaryOptions;
    readonly source: string;
    static readonly cachedWordsLimit = 50000;
    private _size;
    readonly knownWords: Set<string>;
    readonly unknownWords: Set<string>;
    readonly mapWord: (word: string) => string;
    readonly type = "SpellingDictionaryFromTrie";
    readonly isDictionaryCaseSensitive: boolean;
    constructor(trie: Trie, name: string, options?: SpellingDictionaryOptions, source?: string, size?: number);
    readonly size: number;
    has(word: string, hasOptions?: HasOptions): boolean;
    private _has;
    private hasAnyForm;
    suggest(word: string, numSuggestions?: number, compoundMethod?: CompoundWordsMethod, numChanges?: number): SuggestionResult[];
    suggest(word: string, suggestOptions: SuggestOptions): SuggestionResult[];
    private _suggest;
    genSuggestions(collector: SuggestionCollector, suggestOptions: SuggestOptions): void;
}
declare function wordSearchForms(word: string, isDictionaryCaseSensitive: boolean, ignoreCase: boolean): string[];
interface DictionaryWordForm {
    w: string;
    p: string;
}
declare function wordDictionaryForms(word: string, isDictionaryCaseSensitive: boolean): IterableIterator<DictionaryWordForm>;
declare function wordDictionaryFormsCollector(isDictionaryCaseSensitive: boolean): (word: string) => Iterable<string>;
export declare function createSpellingDictionaryTrie(data: IterableLike<string>, name: string, source: string, options?: SpellingDictionaryOptions): Promise<SpellingDictionary>;
export declare function hasOptionToSearchOption(opt: HasOptions | undefined): SearchOptions;
export declare const __testMethods: {
    wordSearchForms: typeof wordSearchForms;
    wordDictionaryForms: typeof wordDictionaryForms;
    wordDictionaryFormsCollector: typeof wordDictionaryFormsCollector;
};
