"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Exclude Expressions
// cSpell:ignore anrvtbf
exports.regExMatchUrls = /(?:https?|ftp):\/\/[^\s"]+/gi;
exports.regExHRef = /\bhref\s*=\s*".*?"/gi;
exports.regExHexDigits = /^x?[0-1a-f]+$/i;
exports.regExMatchCommonHexFormats = /(?:#[0-9a-f]{3,8})|(?:0x[0-9a-f]+)|(?:\\u[0-9a-f]{4})|(?:\\x\{[0-9a-f]{4}\})/gi;
// tslint:disable-next-line
exports.regExSpellingGuard = /(?:(?:spell-?checker|cSpell)::?\s*disable(?!-line|-next)\b[\s\S]*?(?:(?:spell-?checker|cSpell)::?\s*enable\b|$))|(?:.*(?:spell-?checker|cSpell)::?\s*disable-line\b.*)|(?:(?:spell-?checker|cSpell)::?\s*disable-next\b.*\r?\n.*\r?\n)/gi;
exports.regExPublicKey = /BEGIN\s+((?:RSA\s+)?PUBLIC)\s+KEY(?:[\w=+\-\/]*\r?\n)+?-*END\s+\1/g;
exports.regExCert = /BEGIN\s+(CERTIFICATE|RSA\s+(?:PRIVATE|PUBLIC)\s+KEY)(?:[\w=+\-\/]*\r?\n)+?-*END\s+\1/g;
exports.regExEscapeCharacters = /\\(?:[anrvtbf]|[xu][a-f0-9]+)/gi;
exports.regExBase64 = /(?:[a-z0-9\/+]{40,}\s*)+(?:[a-z0-9\/+]+=*)?/gi;
// Include Expressions
exports.regExPhpHereDoc = /<<<['"]?(\w+)['"]?[\s\S]+?^\1;/gm;
exports.regExString = /(?:(['"])(?:\\\\|(?:\\\1)|[^\1\n])*?\1)|(?:([`])(?:\\\\|(?:\\\2)|[^\2])+?\2)/g;
// Note: the C Style Comments incorrectly considers '/*' and '//' inside of strings as comments.
exports.regExCStyleComments = /(?:\/\/.*)|(?:\/\*[\s\S]+?\*\/)/g;
exports.rexExPythonStyleComments = /#.*|(?:('''|""")[^\1]+?\1)/gm;
exports.regExEmail = /<?[\w.\-+]+@\w+(\.\w+)+>?/gi;
exports.regExRepeatedChar = /^(\w)\1{3,}$/;
// cSpell:ignore bsha
exports.regExSha = /\bsha\d+-[a-z0-9+\/=]+/gi;
//# sourceMappingURL=RegExpPatterns.js.map