"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const zlib = require("zlib");
const stream = require("stream");
const iterable_to_stream_1 = require("iterable-to-stream");
function writeToFile(filename, data) {
    return writeToFileIterable(filename, [data]);
}
exports.writeToFile = writeToFile;
function writeToFileIterable(filename, data) {
    const sourceStream = iterable_to_stream_1.iterableToStream(data);
    const writeStream = fs.createWriteStream(filename);
    const zip = filename.match(/\.gz$/) ? zlib.createGzip() : new stream.PassThrough();
    return sourceStream.pipe(zip).pipe(writeStream);
}
exports.writeToFileIterable = writeToFileIterable;
function writeToFileIterableP(filename, data) {
    const stream = writeToFileIterable(filename, data);
    return new Promise((resolve, reject) => {
        stream.on('finish', () => resolve());
        stream.on('error', (e) => reject(e));
    });
}
exports.writeToFileIterableP = writeToFileIterableP;
//# sourceMappingURL=fileWriter.js.map