/// <reference types="node" />
export declare function readFile(filename: string, encoding?: BufferEncoding): Promise<string>;
/**
 * Reads a file line by line. The last value emitted by the Observable is always an empty string.
 * @param filename
 * @param encoding defaults to 'utf8'
 */
export declare function lineReaderAsync(filename: string, encoding?: BufferEncoding): AsyncIterable<string>;
/**
 * Emit a file line by line
 * @param filename full path to the file to read.
 * @param encoding defaults to 'utf8'
 */
export declare function streamFileLineByLineAsync(filename: string, encoding?: BufferEncoding): AsyncIterableIterator<string>;
/**
 * Emit a file line by line
 * @param filename full path to the file to read.
 * @param encoding defaults to 'utf8'
 */
export declare function streamLineByLineAsync(stream: NodeJS.ReadableStream, encoding?: BufferEncoding): AsyncIterableIterator<string>;
