export declare type GlobMatch = GlobMatchRule | GlobMatchNoRule;
export interface GlobMatchRule {
    matched: boolean;
    glob: string;
    index: number;
    isNeg: boolean;
}
export interface GlobMatchNoRule {
    matched: false;
}
export declare class GlobMatcher {
    readonly patterns: string | string[];
    readonly root?: string | undefined;
    /**
     * @param filename full path of file to match against.
     * @returns a GlobMatch - information about the match.
     */
    readonly matchEx: (filename: string) => GlobMatch;
    /**
     * Construct a `.gitignore` emulator
     * @param patterns the contents of a `.gitignore` style file or an array of individual glob rules.
     * @param root the working directory
     */
    constructor(patterns: string | string[], root?: string | undefined);
    /**
     * Check to see if a filename matches any of the globs.
     * @param filename full path of the file to check.
     */
    match(filename: string): boolean;
}
