"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var fs = require("fs");
var expandTopic_1 = require("./expandTopic");
exports.expandTopic = expandTopic_1.expandTopic;
var fast = false;
function setFast() {
    fast = true;
}
exports.setFast = setFast;
function sleep(ms, required) {
    if (required === void 0) { required = false; }
    return new Promise(function (resolve) {
        if (required) {
            setTimeout(resolve, ms);
        }
        else {
            setTimeout(resolve, fast ? 0 : ms);
        }
    });
}
exports.sleep = sleep;
function writeText(text, browser, delay) {
    if (delay === void 0) { delay = 0; }
    return __awaiter(this, void 0, void 0, function () {
        var _i, _a, c;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (fast) {
                        return [2 /*return*/, browser.keys(text.split(''))];
                    }
                    _i = 0, _a = text.split('');
                    _b.label = 1;
                case 1:
                    if (!(_i < _a.length)) return [3 /*break*/, 5];
                    c = _a[_i];
                    return [4 /*yield*/, browser.keys([c])];
                case 2:
                    _b.sent();
                    return [4 /*yield*/, sleep(delay)];
                case 3:
                    _b.sent();
                    _b.label = 4;
                case 4:
                    _i++;
                    return [3 /*break*/, 1];
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.writeText = writeText;
function deleteTextWithBackspaces(element, browser, delay, count) {
    if (delay === void 0) { delay = 0; }
    if (count === void 0) { count = 0; }
    return __awaiter(this, void 0, void 0, function () {
        var length, _a, i;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    if (!(count > 0)) return [3 /*break*/, 1];
                    _a = count;
                    return [3 /*break*/, 3];
                case 1: return [4 /*yield*/, element.getValue()];
                case 2:
                    _a = (_b.sent()).length;
                    _b.label = 3;
                case 3:
                    length = _a;
                    i = 0;
                    _b.label = 4;
                case 4:
                    if (!(i < length)) return [3 /*break*/, 8];
                    return [4 /*yield*/, browser.keys(['Backspace'])];
                case 5:
                    _b.sent();
                    return [4 /*yield*/, sleep(delay)];
                case 6:
                    _b.sent();
                    _b.label = 7;
                case 7:
                    i += 1;
                    return [3 /*break*/, 4];
                case 8: return [2 /*return*/];
            }
        });
    });
}
exports.deleteTextWithBackspaces = deleteTextWithBackspaces;
function setTextInInput(name, text, browser) {
    return __awaiter(this, void 0, void 0, function () {
        var input;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, browser.$("//label[contains(text(), \"" + name + "\")]/..//input")];
                case 1:
                    input = _a.sent();
                    return [4 /*yield*/, clickOn(input, browser, 1)];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, input.clearValue()];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, browser.keys(text)];
                case 4:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.setTextInInput = setTextInInput;
function moveToCenterOfElement(element, browser) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, x, y, _b, width, height, targetX, targetY, duration, js;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4 /*yield*/, element.getLocation()];
                case 1:
                    _a = _c.sent(), x = _a.x, y = _a.y;
                    return [4 /*yield*/, element.getSize()];
                case 2:
                    _b = _c.sent(), width = _b.width, height = _b.height;
                    targetX = x + width / 2;
                    targetY = y + height / 2;
                    duration = fast ? 1 : 500;
                    js = "window.demo.moveMouse(" + targetX + ", " + targetY + ", " + duration + ");";
                    return [4 /*yield*/, browser.execute(js)];
                case 3:
                    _c.sent();
                    return [4 /*yield*/, sleep(duration)];
                case 4:
                    _c.sent();
                    return [4 /*yield*/, sleep(250, true)];
                case 5:
                    _c.sent();
                    return [4 /*yield*/, element.moveTo()];
                case 6:
                    _c.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.moveToCenterOfElement = moveToCenterOfElement;
function clickOnHistory(browser) {
    return __awaiter(this, void 0, void 0, function () {
        var messageHistory;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, browser.$('//span/*[contains(text(), "History")]')];
                case 1:
                    messageHistory = _a.sent();
                    return [4 /*yield*/, clickOn(messageHistory, browser)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.clickOnHistory = clickOnHistory;
function clickOn(element, browser, clicks) {
    if (clicks === void 0) { clicks = 1; }
    return __awaiter(this, void 0, void 0, function () {
        var i;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, moveToCenterOfElement(element, browser)];
                case 1:
                    _a.sent();
                    i = 0;
                    _a.label = 2;
                case 2:
                    if (!(i < clicks)) return [3 /*break*/, 6];
                    return [4 /*yield*/, element.click()];
                case 3:
                    _a.sent();
                    return [4 /*yield*/, sleep(50)];
                case 4:
                    _a.sent();
                    _a.label = 5;
                case 5:
                    i += 1;
                    return [3 /*break*/, 2];
                case 6: return [2 /*return*/];
            }
        });
    });
}
exports.clickOn = clickOn;
function createFakeMousePointer(browser) {
    return __awaiter(this, void 0, void 0, function () {
        var js;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    js = 'window.demo.enableMouse();';
                    return [4 /*yield*/, browser.execute(js)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.createFakeMousePointer = createFakeMousePointer;
function showText(text, duration, browser, location, keys) {
    if (duration === void 0) { duration = 0; }
    if (location === void 0) { location = 'bottom'; }
    if (keys === void 0) { keys = []; }
    return __awaiter(this, void 0, void 0, function () {
        var js;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    js = "window.demo.showMessage('" + text + "', '" + location + "', " + duration + ");";
                    return [4 /*yield*/, browser.execute(js)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.showText = showText;
function getHeapDump(browser) {
    return __awaiter(this, void 0, void 0, function () {
        var filename, js, buffer;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    filename = 'heapdump.json';
                    js = "window.demo.writeHeapdump('" + filename + "');";
                    return [4 /*yield*/, browser.execute(js)];
                case 1:
                    _a.sent();
                    buffer = fs.readFileSync(filename);
                    fs.unlinkSync(filename);
                    return [2 /*return*/, JSON.parse(buffer.toString())];
            }
        });
    });
}
exports.getHeapDump = getHeapDump;
var ClassNameMapping;
(function (ClassNameMapping) {
    ClassNameMapping["TreeNode"] = "TreeNode_TreeNode";
    ClassNameMapping["TreeNodeComponent"] = "TreeNode_TreeNodeComponent";
    ClassNameMapping["Tree"] = "Tree_Tree";
})(ClassNameMapping = exports.ClassNameMapping || (exports.ClassNameMapping = {}));
function countInstancesOf(heapDump, className) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, heapDump.nodes.map(function (idx) { return heapDump.strings[idx]; }).filter(function (s) { return s === className; }).length];
        });
    });
}
exports.countInstancesOf = countInstancesOf;
function showKeys(text, duration, browser, location, keys) {
    if (duration === void 0) { duration = 0; }
    if (location === void 0) { location = 'bottom'; }
    if (keys === void 0) { keys = []; }
    return __awaiter(this, void 0, void 0, function () {
        var js;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    js = "window.demo.showMessage('" + text + "', '" + location + "', " + duration + ", " + JSON.stringify(keys) + ");";
                    return [4 /*yield*/, browser.execute(js)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.showKeys = showKeys;
function hideText(browser) {
    return __awaiter(this, void 0, void 0, function () {
        var js;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    js = 'window.demo.hideMessage();';
                    return [4 /*yield*/, browser.execute(js)];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, sleep(600)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.hideText = hideText;
//# sourceMappingURL=index.js.map