"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var mqtt = require("mqtt");
var mqttClient;
function startServer() {
    var _this = this;
    return new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, connectMqtt()];
                case 1:
                    mqttClient = _a.sent();
                    generateData(mqttClient);
                    resolve(mqttClient);
                    return [2 /*return*/];
            }
        });
    }); });
}
function connectMqtt() {
    return new Promise(function (resolve) {
        var client = mqtt.connect('mqtt://127.0.0.1:1883', {
            username: '',
            password: ''
        });
        client.once('connect', function () {
            resolve(client);
        });
    });
}
function temperature(base, sineCoefficient, offset, speed) {
    if (base === void 0) { base = 18; }
    if (sineCoefficient === void 0) { sineCoefficient = 2; }
    if (offset === void 0) { offset = 0; }
    if (speed === void 0) { speed = 1; }
    var temp = base + Math.sin((Date.now() * speed) / 1000 / 5 + offset) * sineCoefficient + Math.random();
    return String(Math.round(temp * 100) / 100);
}
function stopUpdates() {
    for (var _i = 0, intervals_1 = intervals; _i < intervals_1.length; _i++) {
        var interval = intervals_1[_i];
        clearInterval(interval);
    }
    intervals = [];
}
exports.stopUpdates = stopUpdates;
function stop() {
    stopUpdates();
    try {
        mqttClient && mqttClient.end();
    }
    catch (_a) {
        // ignore
    }
}
exports.stop = stop;
var intervals = [];
function generateData(client) {
    client.publish('livingroom/lamp/state', 'on', { retain: true, qos: 0 });
    client.publish('livingroom/lamp/brightness', '128', { retain: true, qos: 0 });
    client.publish('livingroom/thermostat/targetTemperature', '20°C', {
        retain: true,
        qos: 0
    });
    intervals.push(setInterval(function () { return client.publish('livingroom/temperature', temperature(), { retain: true, qos: 0 }); }, 1000));
    intervals.push(setInterval(function () { return client.publish('livingroom/humidity', temperature(60, -2, 0)); }, 1000));
    client.publish('livingroom/lamp-1/state', 'on', { retain: true, qos: 0 });
    client.publish('livingroom/lamp-1/brightness', '48', {
        retain: true,
        qos: 0
    });
    client.publish('livingroom/lamp-2/state', 'off', { retain: true, qos: 0 });
    client.publish('livingroom/lamp-2/brightness', '48', {
        retain: true,
        qos: 0
    });
    client.publish('kitchen/lamp/state', 'off', { retain: true, qos: 0 });
    client.subscribe('kitchen/lamp/set');
    client.on('message', function (topic, payload) {
        if (topic === 'kitchen/lamp/set') {
            setTimeout(function () {
                try {
                    client.publish('kitchen/lamp/state', JSON.parse(payload.toString()).state, {
                        retain: true,
                        qos: 0
                    });
                }
                catch (error) {
                    console.error(error);
                }
            }, 500);
        }
    });
    var coffeeMaker = {
        heater: 'on',
        temperature: 92.5,
        waterLevel: 0.5,
        update: new Date()
    };
    intervals.push(setInterval(function () {
        var newTemp = parseFloat(temperature(90.3, -5, 0, 3));
        coffeeMaker.heater = newTemp > coffeeMaker.temperature ? 'on' : 'off';
        coffeeMaker.temperature = newTemp;
        client.publish('kitchen/coffee_maker', JSON.stringify(coffeeMaker), { retain: true, qos: 2 });
    }, 1500));
    intervals.push(setInterval(function () { return client.publish('kitchen/temperature', temperature(), { retain: true, qos: 0 }); }, 1500));
    intervals.push(setInterval(function () { return client.publish('kitchen/humidity', temperature(60, -5, 0), { retain: true, qos: 0 }); }, 1800));
    client.publish('garden/pump/state', 'off', { retain: true, qos: 0 });
    client.publish('garden/water/level', '70%', { retain: true, qos: 0 });
    client.publish('garden/lamps/state', 'off', { retain: true, qos: 0 });
    client.publish('garden/lamps/state', 'off', { retain: true, qos: 0 });
    client.publish('zigbee2mqtt/bridge/state', 'online', {
        retain: true,
        qos: 0
    });
    client.publish('ble2mqtt/bridge/state', 'online', { retain: true, qos: 0 });
    // Used for demonstrating "clean up"
    client.publish('test 123', 'Hello world', { retain: true, qos: 0 });
    client.publish('hello', 'sunshine', { retain: true, qos: 0 });
    // Just stuff
    client.publish('01-80-C2-00-00-0F/LWT', 'offline', { retain: true, qos: 0 });
    intervals.push(setInterval(function () {
        client.publish('3d-printer/OctoPrint/temperature/bed', '{"_timestamp":1548589083,"actual":25.9,"target":0}');
        client.publish('3d-printer/OctoPrint/temperature/tool0', '{"_timestamp":1548589093,"actual":26.4,"target":0}');
    }, 3333));
    var state = true;
    intervals.push(setInterval(function () {
        state = !state;
        var js = {
            tags: {
                entityId: 33512,
                entityType: 'person',
                host: 'd44ad81e10f9',
                server: 'http://localhost/dataActuality',
                status: state ? 'live' : 'inactive'
            },
            timestamp: Date.now()
        };
        client.publish('actuality/showcase', JSON.stringify(js), {
            retain: true,
            qos: 0
        });
    }, 2102));
}
exports["default"] = startServer;
//# sourceMappingURL=mock-mqtt.js.map