"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var os = require("os");
var mock_mqtt_1 = require("./mock-mqtt");
var util_1 = require("./util");
var searchTree_1 = require("./scenarios/searchTree");
var connect_1 = require("./scenarios/connect");
var reconnect_1 = require("./scenarios/reconnect");
process.on('unhandledRejection', function (error) {
    console.error('unhandledRejection', error.message, error.stack);
    process.exit(1);
});
var runningUiTestOnCi = os.platform() === 'darwin' ? [] : ['--runningUiTestOnCi'];
console.log(__dirname + "/../../../node_modules/.bin/electron");
var options = {
    host: '127.0.0.1',
    port: 9515,
    capabilities: {
        browserName: 'electron',
        chromeOptions: {
            binary: __dirname + "/../../../node_modules/.bin/electron",
            args: [
                "--app=" + __dirname + "/../../..",
                '--force-device-scale-factor=1',
                '--no-sandbox',
                '--disable-dev-shm-usage',
                '--disable-extensions',
            ].concat(runningUiTestOnCi)
        },
        windowTypes: ['app', 'webview']
    }
};
function doStuff() {
    return __awaiter(this, void 0, void 0, function () {
        var browser, heapDump, initialTreeOccurrences, initialNodeOccurrences;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    console.log('Waiting for MQTT Broker on port 1880 (no auth)');
                    return [4 /*yield*/, mock_mqtt_1["default"]()];
                case 1:
                    _a.sent();
                    console.log('start webdriver');
                    return [4 /*yield*/, WebdriverIO.remote(options)];
                case 2:
                    browser = _a.sent();
                    util_1.setFast();
                    return [4 /*yield*/, util_1.createFakeMousePointer(browser)
                        // Wait for Username input to be visible
                    ];
                case 3:
                    _a.sent();
                    // Wait for Username input to be visible
                    return [4 /*yield*/, browser.$('//label[contains(text(), "Username")]/..//input')];
                case 4:
                    // Wait for Username input to be visible
                    _a.sent();
                    return [4 /*yield*/, connect_1.connectTo('127.0.0.1', browser)];
                case 5:
                    _a.sent();
                    mock_mqtt_1.stopUpdates();
                    return [4 /*yield*/, util_1.sleep(1000, true)];
                case 6:
                    _a.sent();
                    return [4 /*yield*/, util_1.getHeapDump(browser)];
                case 7:
                    heapDump = _a.sent();
                    return [4 /*yield*/, util_1.countInstancesOf(heapDump, util_1.ClassNameMapping.Tree)];
                case 8:
                    initialTreeOccurrences = _a.sent();
                    return [4 /*yield*/, util_1.countInstancesOf(heapDump, util_1.ClassNameMapping.TreeNode)];
                case 9:
                    initialNodeOccurrences = _a.sent();
                    console.log(initialTreeOccurrences, initialNodeOccurrences);
                    return [4 /*yield*/, doX(3, function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, reconnect_1.reconnect(browser)];
                                    case 1:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 10:
                    _a.sent();
                    return [4 /*yield*/, util_1.sleep(1000, true)];
                case 11:
                    _a.sent();
                    return [4 /*yield*/, doX(15, function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, searchTree_1.searchTree('temp', browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, reconnect_1.reconnect(browser)];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 12:
                    _a.sent();
                    return [4 /*yield*/, searchTree_1.searchTree('ab', browser)];
                case 13:
                    _a.sent();
                    return [4 /*yield*/, searchTree_1.clearSearch(browser)];
                case 14:
                    _a.sent();
                    return [4 /*yield*/, searchTree_1.searchTree('temp', browser)];
                case 15:
                    _a.sent();
                    return [4 /*yield*/, searchTree_1.clearSearch(browser)];
                case 16:
                    _a.sent();
                    return [4 /*yield*/, util_1.sleep(1000, true)];
                case 17:
                    _a.sent();
                    return [4 /*yield*/, waitForGarbageCollectorToDetermineLeak(browser, initialTreeOccurrences, initialNodeOccurrences)];
                case 18:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
function waitForGarbageCollectorToDetermineLeak(browser, initialTreeOccurrences, initialNodeOccurrences) {
    return __awaiter(this, void 0, void 0, function () {
        var delta, lastTreeOccurrences, lastNodeOccurrences, leak, heapDump, currentTreeOccurrences, currentNodeOccurrences, treeDelta, nodeDelta;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    delta = -1;
                    lastTreeOccurrences = -1;
                    lastNodeOccurrences = -1;
                    leak = false;
                    _a.label = 1;
                case 1:
                    if (!(delta < 0)) return [3 /*break*/, 7];
                    if (!(lastTreeOccurrences !== -1)) return [3 /*break*/, 3];
                    return [4 /*yield*/, util_1.sleep(10000, true)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3: return [4 /*yield*/, util_1.getHeapDump(browser)];
                case 4:
                    heapDump = _a.sent();
                    return [4 /*yield*/, util_1.countInstancesOf(heapDump, util_1.ClassNameMapping.Tree)];
                case 5:
                    currentTreeOccurrences = _a.sent();
                    return [4 /*yield*/, util_1.countInstancesOf(heapDump, util_1.ClassNameMapping.TreeNode)
                        // Temporary "leaks" are expected due to React Fibers memoization
                    ];
                case 6:
                    currentNodeOccurrences = _a.sent();
                    // Temporary "leaks" are expected due to React Fibers memoization
                    if (Math.abs(initialTreeOccurrences - currentTreeOccurrences) > 1 ||
                        Math.abs(currentNodeOccurrences - initialNodeOccurrences) > 8) {
                        console.error('Possible leak detected', initialTreeOccurrences, currentTreeOccurrences, initialNodeOccurrences, currentNodeOccurrences);
                        leak = true;
                    }
                    else {
                        leak = false;
                    }
                    treeDelta = lastTreeOccurrences >= 0 ? currentTreeOccurrences - lastTreeOccurrences : -1;
                    nodeDelta = lastTreeOccurrences >= 0 ? currentNodeOccurrences - lastNodeOccurrences : -1;
                    delta = treeDelta + nodeDelta;
                    lastTreeOccurrences = currentTreeOccurrences;
                    lastNodeOccurrences = currentNodeOccurrences;
                    return [3 /*break*/, 1];
                case 7:
                    if (leak) {
                        console.error('leak');
                        process.exit(100);
                    }
                    return [2 /*return*/];
            }
        });
    });
}
function doX(x, action) {
    return __awaiter(this, void 0, void 0, function () {
        var i;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < x)) return [3 /*break*/, 5];
                    return [4 /*yield*/, action()];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, util_1.sleep(10, true)];
                case 3:
                    _a.sent();
                    _a.label = 4;
                case 4:
                    i += 1;
                    return [3 /*break*/, 1];
                case 5: return [2 /*return*/];
            }
        });
    });
}
doStuff();
//# sourceMappingURL=leakTest.js.map