"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var fs = require("fs");
var os = require("os");
var webdriverio = require("webdriverio");
var mock_mqtt_1 = require("./mock-mqtt");
var clearOldTopics_1 = require("./scenarios/clearOldTopics");
var searchTree_1 = require("./scenarios/searchTree");
var util_1 = require("./util");
var connect_1 = require("./scenarios/connect");
var copyTopicToClipboard_1 = require("./scenarios/copyTopicToClipboard");
var copyValueToClipboard_1 = require("./scenarios/copyValueToClipboard");
var disconnect_1 = require("./scenarios/disconnect");
var publishTopic_1 = require("./scenarios/publishTopic");
var SceneBuilder_1 = require("./SceneBuilder");
var showAdvancedConnectionSettings_1 = require("./scenarios/showAdvancedConnectionSettings");
var showJsonPreview_1 = require("./scenarios/showJsonPreview");
var showMenu_1 = require("./scenarios/showMenu");
var showNumericPlot_1 = require("./scenarios/showNumericPlot");
var showOffDiffCapability_1 = require("./scenarios/showOffDiffCapability");
var showZoomLevel_1 = require("./scenarios/showZoomLevel");
process.on('unhandledRejection', function (error) {
    console.error('unhandledRejection', error.message, error.stack);
    process.exit(1);
});
var runningUiTestOnCi = os.platform() === 'darwin' ? [] : ['--runningUiTestOnCi'];
console.log(__dirname + "/../../../node_modules/.bin/electron");
var options = {
    host: '127.0.0.1',
    port: 9515,
    capabilities: {
        browserName: 'electron',
        chromeOptions: {
            binary: __dirname + "/../../../node_modules/.bin/electron",
            args: [
                "--app=" + __dirname + "/../../..",
                '--force-device-scale-factor=1',
                '--no-sandbox',
                '--disable-dev-shm-usage',
                '--disable-extensions',
            ].concat(runningUiTestOnCi)
        },
        windowTypes: ['app', 'webview']
    }
};
function doStuff() {
    return __awaiter(this, void 0, void 0, function () {
        var browser, scenes;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    console.log('Waiting for MQTT Broker on port 1880 (no auth)');
                    return [4 /*yield*/, mock_mqtt_1["default"]()];
                case 1:
                    _a.sent();
                    console.log('start webdriver');
                    return [4 /*yield*/, webdriverio.remote(options)];
                case 2:
                    browser = _a.sent();
                    return [4 /*yield*/, util_1.createFakeMousePointer(browser)
                        // Wait for Username input to be visible
                    ];
                case 3:
                    _a.sent();
                    // Wait for Username input to be visible
                    return [4 /*yield*/, browser.$('//label[contains(text(), "Username")]/..//input')];
                case 4:
                    // Wait for Username input to be visible
                    _a.sent();
                    scenes = new SceneBuilder_1.SceneBuilder();
                    return [4 /*yield*/, scenes.record('connect', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, connect_1.connectTo('127.0.0.1', browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(1000)];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 5:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('numeric_plots', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.showText('Plot topic history', 1500, browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, showNumericPlot_1.showNumericPlot(browser)];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(2000)];
                                    case 3:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 6:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('json-formatting', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, showJsonPreview_1.showJsonPreview(browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.showText('Formatted messages', 1500, browser, 'top')];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(1500)];
                                    case 3:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 7:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('diffs', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, showOffDiffCapability_1.showOffDiffCapability(browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.hideText(browser)];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 8:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('publish_topic', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.showText('Publish topics', 1500, browser, 'top')];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.clickOnHistory(browser)];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, publishTopic_1.publishTopic(browser)];
                                    case 3:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(1000)];
                                    case 4:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 9:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('clipboard', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.showText('Copy to Clipboard', 1500, browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, copyTopicToClipboard_1.copyTopicToClipboard(browser)];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.hideText(browser)];
                                    case 3:
                                        _a.sent();
                                        return [4 /*yield*/, copyValueToClipboard_1.copyValueToClipboard(browser)];
                                    case 4:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(1000)];
                                    case 5:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 10:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('topic_filter', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.showText('Search topic hierarchy', 0, browser, 'middle')];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, searchTree_1.searchTree('temp', browser)];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.hideText(browser)];
                                    case 3:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.showText('Topics containing "temp"', 1500, browser)];
                                    case 4:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(1500)];
                                    case 5:
                                        _a.sent();
                                        return [4 /*yield*/, searchTree_1.clearSearch(browser)];
                                    case 6:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(1000)];
                                    case 7:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 11:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('delete_retained_topics', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.hideText(browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.showText('Delete retained topics', 5000, browser)];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, clearOldTopics_1.clearOldTopics(browser)];
                                    case 3:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.hideText(browser)];
                                    case 4:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 12:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('settings', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.showText('Settings', 1500, browser)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, showMenu_1.showMenu(browser)];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 13:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('customize_subscriptions', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.sleep(2000)];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, disconnect_1.disconnect(browser)];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.showText('Customize Subscriptions', 1500, browser, 'top')];
                                    case 3:
                                        _a.sent();
                                        return [4 /*yield*/, showAdvancedConnectionSettings_1.showAdvancedConnectionSettings(browser)];
                                    case 4:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 14:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('keyboard_shortcuts', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.showText('Keyboard shortcuts', 1500, browser, 'middle')];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(1750)];
                                    case 2:
                                        _a.sent();
                                        return [4 /*yield*/, showZoomLevel_1.showZoomLevel(browser)];
                                    case 3:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 15:
                    _a.sent();
                    return [4 /*yield*/, scenes.record('end', function () { return __awaiter(_this, void 0, void 0, function () {
                            return __generator(this, function (_a) {
                                switch (_a.label) {
                                    case 0: return [4 /*yield*/, util_1.showText('The End', 3000, browser, 'middle')];
                                    case 1:
                                        _a.sent();
                                        return [4 /*yield*/, util_1.sleep(3000)];
                                    case 2:
                                        _a.sent();
                                        return [2 /*return*/];
                                }
                            });
                        }); })];
                case 16:
                    _a.sent();
                    browser.closeWindow();
                    mock_mqtt_1.stop();
                    fs.writeFileSync('scenes.json', JSON.stringify(scenes.scenes, undefined, '  '));
                    return [2 /*return*/];
            }
        });
    });
}
doStuff();
//# sourceMappingURL=demoVideo.js.map