"use strict";
exports.__esModule = true;
var electron_updater_1 = require("electron-updater");
function shouldAutoUpdate(build) {
    return (build.package !== 'portable' &&
        build.package !== 'appx' &&
        build.package !== 'snap' &&
        build.package !== 'mas' &&
        build.platform !== 'mac');
}
exports.shouldAutoUpdate = shouldAutoUpdate;
function handleAutoUpdate() {
    electron_updater_1.autoUpdater.on('update-available', function (info) {
        console.log('There is an update available');
    });
    electron_updater_1.autoUpdater.on('error', function (error) {
        console.error('could not update due to error', error);
    });
    try {
        electron_updater_1.autoUpdater.checkForUpdatesAndNotify();
    }
    catch (error) {
        console.error(error);
    }
}
exports.handleAutoUpdate = handleAutoUpdate;
//# sourceMappingURL=autoUpdater.js.map