"use strict";
exports.__esModule = true;
var electron_1 = require("electron");
var about_window_1 = require("about-window");
var path = require("path");
var applicationMenu = {
    label: 'Application',
    submenu: [
        {
            label: 'About Application',
            click: function () {
                about_window_1["default"]({
                    icon_path: path.join(__dirname, '..', '..', 'icon.png'),
                    license: 'CC-BY-ND-4.0',
                    homepage: 'https://thomasnordquist.github.io/MQTT-Explorer/',
                    bug_report_url: 'https://github.com/thomasnordquist/MQTT-Explorer/issues',
                    description: 'Author: Thomas Nordquist'
                });
            }
        },
        {
            type: 'separator'
        },
        {
            label: 'Dev Tools',
            accelerator: 'CmdOrCtrl+Alt+I',
            role: 'toggledevtools'
        },
        {
            label: 'Quit',
            accelerator: 'Command+Q',
            click: function () {
                electron_1.app.quit();
            }
        },
    ]
};
var editMenu = {
    label: 'Edit',
    submenu: [
        {
            label: 'Undo',
            accelerator: 'CmdOrCtrl+Z',
            role: 'undo'
        },
        {
            label: 'Redo',
            accelerator: 'Shift+CmdOrCtrl+Z',
            role: 'redo'
        },
        {
            type: 'separator'
        },
        {
            label: 'Cut',
            accelerator: 'CmdOrCtrl+X',
            role: 'cut'
        },
        {
            label: 'Copy',
            accelerator: 'CmdOrCtrl+C',
            role: 'copy'
        },
        {
            label: 'Paste',
            accelerator: 'CmdOrCtrl+V',
            role: 'paste'
        },
        {
            label: 'Select All',
            accelerator: 'CmdOrCtrl+A',
            role: 'selectall'
        },
    ]
};
var viewMenu = {
    label: 'View',
    submenu: [
        {
            label: 'Default size',
            accelerator: 'CmdOrCtrl+0',
            click: function () {
                var window = electron_1.BrowserWindow.getFocusedWindow();
                if (window) {
                    window.webContents.setZoomFactor(1);
                }
            }
        },
        {
            label: 'Increase size',
            accelerator: 'CmdOrCtrl+Plus',
            click: function () {
                var window = electron_1.BrowserWindow.getFocusedWindow();
                if (window) {
                    var zoom = window.webContents.getZoomFactor();
                    window.webContents.setZoomFactor(Math.min(zoom + 0.1, 2.0));
                }
            }
        },
        {
            label: 'Reduce size',
            accelerator: 'CmdOrCtrl+-',
            click: function () {
                var window = electron_1.BrowserWindow.getFocusedWindow();
                if (window) {
                    var zoom = window.webContents.getZoomFactor();
                    window.webContents.setZoomFactor(Math.max(zoom - 0.1, 0.5));
                }
            }
        },
    ]
};
var template = [applicationMenu, editMenu, viewMenu];
exports.menuTemplate = electron_1.Menu.buildFromTemplate(template);
//# sourceMappingURL=MenuTemplate.js.map