#!node_modules/.bin/ts-node
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var axios_1 = require("axios");
var fs = require("fs");
var path = require("path");
var mime = require("mime");
var githubToken = process.env.GH_TOKEN;
function tagUrl(tag) {
    return __awaiter(this, void 0, void 0, function () {
        var response, tagRelease;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, axios_1["default"].get("https://api.github.com/repos/thomasnordquist/mqtt-explorer/releases?access_token=" + githubToken)];
                case 1:
                    response = _a.sent();
                    tagRelease = response.data.find(function (release) { return release.tag_name === tag; });
                    return [2 /*return*/, tagRelease ? cleanUploadUrl(tagRelease.upload_url) : undefined];
            }
        });
    });
}
function createDraft(tag) {
    return __awaiter(this, void 0, void 0, function () {
        var response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    console.log('create draft');
                    return [4 /*yield*/, axios_1["default"]({
                            method: 'post',
                            url: "https://api.github.com/repos/thomasnordquist/mqtt-explorer/releases?access_token=" + githubToken,
                            data: {
                                tag_name: tag,
                                name: tag.slice(1),
                                draft: true
                            }
                        })];
                case 1:
                    response = _a.sent();
                    return [2 /*return*/, cleanUploadUrl(response.data.upload_url)];
            }
        });
    });
}
function cleanUploadUrl(url) {
    var match = url.match(/(.*){/);
    return match ? match[1] : undefined;
}
function uploadAsset() {
    return __awaiter(this, void 0, void 0, function () {
        var tag, files, uploadUrl, error_1, error_2, _i, files_1, file;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    tag = process.env.GIT_TAG;
                    files = process.argv.slice(2);
                    if (!tag || files.length === 0) {
                        console.log('Nothing to do');
                        return [2 /*return*/];
                    }
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 7, , 8]);
                    return [4 /*yield*/, tagUrl(tag)];
                case 2:
                    uploadUrl = _a.sent();
                    if (!!uploadUrl) return [3 /*break*/, 6];
                    console.log('tag does not exist');
                    _a.label = 3;
                case 3:
                    _a.trys.push([3, 5, , 6]);
                    return [4 /*yield*/, createDraft(tag)];
                case 4:
                    uploadUrl = _a.sent();
                    return [3 /*break*/, 6];
                case 5:
                    error_1 = _a.sent();
                    console.error('failed to create draft', error_1.stack);
                    process.exit(1);
                    return [3 /*break*/, 6];
                case 6: return [3 /*break*/, 8];
                case 7:
                    error_2 = _a.sent();
                    console.error('failed to find tag release', error_2.stack);
                    process.exit(1);
                    return [3 /*break*/, 8];
                case 8:
                    if (!uploadUrl) return [3 /*break*/, 12];
                    console.log(uploadUrl);
                    _i = 0, files_1 = files;
                    _a.label = 9;
                case 9:
                    if (!(_i < files_1.length)) return [3 /*break*/, 12];
                    file = files_1[_i];
                    console.log('uploading file', file);
                    return [4 /*yield*/, uploadFile(uploadUrl, file)];
                case 10:
                    _a.sent();
                    console.log('upload completed');
                    _a.label = 11;
                case 11:
                    _i++;
                    return [3 /*break*/, 9];
                case 12: return [2 /*return*/];
            }
        });
    });
}
function uploadFile(uploadUrl, file) {
    return __awaiter(this, void 0, void 0, function () {
        var data, mimeType;
        return __generator(this, function (_a) {
            data = fs.readFileSync(file);
            mimeType = mime.getType(path.extname(file));
            return [2 /*return*/, axios_1["default"]({
                    data: data,
                    method: 'post',
                    url: uploadUrl + "?name=" + path.basename(file) + "&access_token=" + githubToken,
                    headers: {
                        'Content-Type': mimeType
                    }
                })];
        });
    });
}
uploadAsset();
//# sourceMappingURL=uploadVideoAsset.js.map