"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var fs = require("fs-extra");
var path = require("path");
var process_1 = require("process");
var util_1 = require("./util");
var targetDir = path.join('build', 'clean');
function prepareRelease() {
    return __awaiter(this, void 0, void 0, function () {
        var originalDir;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    originalDir = __dirname;
                    return [4 /*yield*/, fs.remove(targetDir)];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, fs.mkdirp(targetDir)
                        // Create fresh clone of the local git repo
                    ];
                case 2:
                    _a.sent();
                    // Create fresh clone of the local git repo
                    return [4 /*yield*/, util_1.exec('git', ['clone', '.git', targetDir])
                        // Enter git repo
                    ];
                case 3:
                    // Create fresh clone of the local git repo
                    _a.sent();
                    // Enter git repo
                    process_1.chdir(targetDir);
                    // Install app dependencies
                    process_1.chdir('app');
                    return [4 /*yield*/, util_1.exec('yarn')];
                case 4:
                    _a.sent();
                    process_1.chdir('..');
                    // Install electron dependencies
                    return [4 /*yield*/, util_1.exec('yarn')
                        // Build App and Electron backend
                    ];
                case 5:
                    // Install electron dependencies
                    _a.sent();
                    // Build App and Electron backend
                    return [4 /*yield*/, util_1.exec('yarn', ['build'])
                        // Clean up
                    ];
                case 6:
                    // Build App and Electron backend
                    _a.sent();
                    // Clean up
                    return [4 /*yield*/, fs.remove('node_modules')
                        // await exec('yarn', ['install', '--production']) // Do not clean up, electron version detection will fail otherwise
                    ];
                case 7:
                    // Clean up
                    _a.sent();
                    // await exec('yarn', ['install', '--production']) // Do not clean up, electron version detection will fail otherwise
                    return [4 /*yield*/, fs.remove(path.join('app', 'node_modules'))];
                case 8:
                    // await exec('yarn', ['install', '--production']) // Do not clean up, electron version detection will fail otherwise
                    _a.sent();
                    process_1.chdir(originalDir);
                    return [2 /*return*/];
            }
        });
    });
}
prepareRelease();
//# sourceMappingURL=prepare-release.js.map