#!./node_modules/.bin/ts-node
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var fs = require("fs");
var util_1 = require("./util");
// tslint:disable-next-line
var concat = require('ffmpeg-concat');
function cutScenes(scenes) {
    return __awaiter(this, void 0, void 0, function () {
        var _i, scenes_1, scene, outputFile;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _i = 0, scenes_1 = scenes;
                    _a.label = 1;
                case 1:
                    if (!(_i < scenes_1.length)) return [3 /*break*/, 4];
                    scene = scenes_1[_i];
                    outputFile = scene.name + ".mp4";
                    if (fs.existsSync(outputFile)) {
                        fs.unlinkSync(outputFile);
                    }
                    return [4 /*yield*/, util_1.exec('ffmpeg', ("-i app2.mp4 -ss " + scene.start / 1000 + " -t " + scene.duration / 1000 + " " + scene.name + ".mp4").split(' '))];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4: return [2 /*return*/];
            }
        });
    });
}
var TransitionBuilder = /** @class */ (function () {
    function TransitionBuilder() {
        this.scenes = [];
        this.transitions = [];
    }
    TransitionBuilder.prototype.startWith = function (scene) {
        this.scenes.push(scene);
        return this;
    };
    TransitionBuilder.prototype.transitionTo = function (scene, transition) {
        this.scenes.push(scene);
        this.transitions.push(transition);
        return this;
    };
    TransitionBuilder.prototype.buildOptions = function (outputFile) {
        return {
            output: outputFile,
            videos: this.scenes.map(function (s) { return s + ".mp4"; }),
            transitions: this.transitions.map(function (name) { return ({
                name: name !== 'none' ? name : 'fade',
                duration: name !== 'none' ? 1000 : 10
            }); })
        };
    };
    return TransitionBuilder;
}());
// const scenes: Array<Scene> = JSON.parse(fs.readFileSync('./scenes.json').toString())
// cutScenes(scenes)
var builder = new TransitionBuilder()
    .startWith('connect')
    .transitionTo('numeric_plots', 'cube')
    .transitionTo('diffs', 'pixelize')
    .transitionTo('customize_subscriptions', 'hexagonalize');
concat(builder.buildOptions('test.mp4'));
//# sourceMappingURL=cutScenes.js.map