"use strict";
exports.__esModule = true;
var IpcRendererEventBus = /** @class */ (function () {
    function IpcRendererEventBus(ipc) {
        this.callbacks = [];
        this.ipc = ipc;
    }
    IpcRendererEventBus.prototype.subscribe = function (event, callback) {
        var wrappedCallback = function (_, arg) {
            callback(arg);
        };
        this.ipc.on(event.topic, wrappedCallback);
        this.callbacks.push({
            callback: callback,
            wrappedCallback: wrappedCallback
        });
    };
    IpcRendererEventBus.prototype.unsubscribeAll = function (event) {
        this.ipc.removeAllListeners(event.topic);
    };
    IpcRendererEventBus.prototype.unsubscribe = function (event, callback) {
        var item = this.callbacks.find(function (store) { return store.callback === callback; });
        if (!item) {
            return;
        }
        this.ipc.removeListener(event.topic, item.wrappedCallback);
        this.callbacks = this.callbacks.filter(function (a) { return a !== item; });
    };
    IpcRendererEventBus.prototype.emit = function (event, msg) {
        this.ipc.send(event.topic, msg);
    };
    return IpcRendererEventBus;
}());
exports.IpcRendererEventBus = IpcRendererEventBus;
//# sourceMappingURL=IpcRendererEventBus.js.map