"use strict";
exports.__esModule = true;
var events_1 = require("events");
var EventDispatcher = /** @class */ (function () {
    function EventDispatcher() {
        this.emitter = new events_1.EventEmitter();
        this.callbacks = [];
    }
    EventDispatcher.prototype.dispatch = function (msg) {
        this.emitter.emit('event', msg);
    };
    EventDispatcher.prototype.subscribe = function (callback) {
        var wrappedCallback = function (msg) {
            callback(msg);
        };
        this.emitter.on('event', wrappedCallback);
        this.callbacks.push({
            callback: callback,
            wrappedCallback: wrappedCallback
        });
    };
    EventDispatcher.prototype.unsubscribe = function (callback) {
        var item = this.callbacks.find(function (store) { return store.callback === callback; });
        if (!item) {
            return;
        }
        this.emitter.removeListener('event', item.wrappedCallback);
        this.callbacks = this.callbacks.filter(function (a) { return a !== item; });
    };
    EventDispatcher.prototype.removeAllListeners = function () {
        this.emitter.removeAllListeners();
        this.callbacks = [];
    };
    return EventDispatcher;
}());
exports.EventDispatcher = EventDispatcher;
//# sourceMappingURL=EventDispatcher.js.map